<?php
require_once __DIR__ . '/../db.php';

$stats = [];

$res = $conn->query("SELECT COUNT(*) AS c FROM vms");
$stats['total_vms'] = (int)$res->fetch_assoc()['c'];

$res = $conn->query("
    SELECT COUNT(*) AS c
    FROM vms
    WHERE last_seen >= NOW() - INTERVAL 15 MINUTE
");
$stats['online_vms'] = (int)$res->fetch_assoc()['c'];

$stats['pending_vms'] = max(
0,
($stats['total_vms'] ?? 0) - ($stats['online_vms'] ?? 0)
);

$res = $conn->query("
    SELECT COUNT(*) AS c
    FROM vms
    WHERE last_seen >= NOW() - INTERVAL 15 MINUTE
      AND (earnapp_running = 0 OR earnapp_paused = 1)
");
$stats['anomalies'] = (int)$res->fetch_assoc()['c'];

$res = $conn->query("
    SELECT IFNULL(SUM(earning),0) AS c
    FROM vm_earnings
    WHERE date = CURDATE()
");
$stats['earning_today'] = (float)$res->fetch_assoc()['c'];

$res = $conn->query("
    SELECT IFNULL(SUM(earning),0) AS c
    FROM vm_earnings
    WHERE MONTH(date)=MONTH(CURDATE())
      AND YEAR(date)=YEAR(CURDATE())
");
$stats['earning_month'] = (float)$res->fetch_assoc()['c'];
?>



<div class="container-fluid px-4 py-3">
  
  <div class="row mb-3">
    <div class="col-md-6">
      <input id="searchInput" class="form-control bg-dark text-white"
             placeholder="Search groups, RDPs, VMs...">
    </div>
    <div class="col-md-6 text-end">
      <button class="btn btn-danger btn-sm" onclick="app.openModal('group')">+ GROUP</button>
      <button class="btn btn-danger btn-sm" onclick="app.openModal('rdp')">+ RDP</button>
      <button class="btn btn-danger btn-sm" onclick="app.openModal('vm')">+ VM</button>
    </div>
  </div>

  <div class="row">
    <div class="col-md-3">
      <div class="card bg-dark text-white">
        <div class="card-header">Navigator</div>
        <ul id="navTree" class="list-group list-group-flush"></ul>
      </div>
    </div>
    <div class="col-md-9">
        <button class="btn btn-outline-danger btn-sm" onclick="app.bulkDelete('vm')">
  Delete VMs
</button>

<button class="btn btn-outline-danger btn-sm" onclick="app.bulkDelete('rdp')">
  Delete RDPs
</button>

<button class="btn btn-outline-danger btn-sm" onclick="app.bulkDelete('group')">
  Delete Groups
</button>
      <div id="mainContent"></div>
    </div>
  </div>
</div>

<div id="overlay" onclick="app.closeModal()"></div>

<?php include __DIR__.'/../modals/group.php'; ?>
<?php include __DIR__.'/../modals/rdp.php'; ?>
<?php include __DIR__.'/../modals/vm.php'; ?>

<div id="terminalModal" class="modal">
  <div class="modal-content bg-dark text-white" style="max-width:900px;width:95%">
    <div class="modal-header border-secondary">
      <h5 class="modal-title">
        <i class="fa fa-terminal me-2"></i>
        <span id="terminalTitle">Terminal</span>
      </h5>
      <button class="btn-close btn-close-white" onclick="app.closeModal()"></button>
    </div>

    <div class="modal-body">

      <div class="card bg-black border-danger mb-3">
        <div class="card-body p-2">
          <div class="row small">
            <div class="col-3">VM ID: <span id="displayVmId"></span></div>
            <div class="col-3">VM: <span id="displayVmName"></span></div>
            <div class="col-3">Group: <span id="displayGroup"></span></div>
            <div class="col-3">RDP: <span id="displayRdp"></span></div>
          </div>
        </div>
      </div>

      <div class="btn-group w-100 mb-3">
        <button class="btn btn-outline-danger active"
                data-mode="install"
                onclick="app.setTerminalMode('install')">Install</button>

         
        <button class="btn btn-outline-danger"
                data-mode="custom"
                onclick="app.setTerminalMode('custom')">Custom</button>
      </div>

      <div id="installSection">
        <div class="input-group mb-3">
          <input id="installCmd" class="form-control bg-black text-success" readonly>
          <button class="btn btn-danger" onclick="app.copyToClipboard('installCmd')">Copy</button>
        </div>
        <div class="input-group mb-3">
          <input id="uninstallCmd" class="form-control bg-black text-success" readonly>
          <button class="btn btn-danger" onclick="app.copyToClipboard('uninstallCmd')">Copy</button>
        </div>
      </div>

      <div id="uninstallSection" style="display:none">
        <div class="input-group mb-3">
          <input id="installCmdCMD" class="form-control bg-black text-warning" readonly>
          <button class="btn btn-danger" onclick="app.copyToClipboard('installCmdCMD')">Copy</button>
        </div>
        <div class="input-group mb-3">
          <input id="uninstallCmdCMD" class="form-control bg-black text-warning" readonly>
          <button class="btn btn-danger" onclick="app.copyToClipboard('uninstallCmdCMD')">Copy</button>
        </div>
      </div>

      <div id="customSection" style="display:none">
        <div class="input-group mb-3">
          <input id="customCmd" class="form-control bg-black text-white">
          <button class="btn btn-danger" onclick="app.executeCustomCommand()">Execute</button>
        </div>
      </div>

    </div>

    <div class="modal-footer border-secondary">
      <button class="btn btn-secondary" onclick="app.closeModal()">Close</button>
      <button class="btn btn-success" onclick="app.copyAllCommands()">Copy All</button>
      <button class="btn btn-danger" onclick="app.sendToVM()">Send to VM</button>
    </div>
  </div>
</div>

<style>
#overlay{position:fixed;top:0;left:0;width:100%;height:100%;background:rgba(0,0,0,.9);display:none;z-index:9998}
.modal{position:fixed;top:0;left:0;width:100%;height:100%;display:none;justify-content:center;align-items:center;z-index:9999}
.modal-content{border:2px solid #ff0000;border-radius:10px;animation:modalFadeIn .3s;box-shadow:0 0 30px rgba(255,0,0,.5)}
@keyframes modalFadeIn{from{opacity:0;transform:scale(.9)}to{opacity:1;transform:scale(1)}}
.btn-group .btn.active,.btn-group .btn-check:checked+.btn{background:#dc3545;border-color:#dc3545;color:#fff}
.btn-group .btn-outline-info.active{background:#0dcaf0;border-color:#0dcaf0;color:#fff}
.form-control[readonly]{cursor:pointer;font-family:Courier New,monospace}
.form-control[readonly]:hover{background:rgba(255,0,0,.1)}
.left-card.d-flex.gap-4 {
    max-width: 100%;
    width: 640px;
}

.border.border-secondary.rounded.p-3.middle {
    max-width: 100%;
    width: 500px;
}

.status1 {
    width: 124px;
}
</style>
 