<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/../db.php';
$db = $conn;

header('Content-Type: application/json');
// date_default_timezone_set('Asia/Kolkata');
date_default_timezone_set('UTC'); 

$input = json_decode(file_get_contents('php://input'), true);
$action = $_GET['action'] ?? ($input['action'] ?? '');

function now() { return date('Y-m-d H:i:s'); }

define('FREEZE_LIMIT', 6);
define('HARD_FREEZE_LIMIT', 20);

switch ($action) {
    case 'send_command':
        $cmd = strtolower($input['command'] ?? '');
        $vmId = (int)($input['vm_id'] ?? 0);
        if ($vmId > 0 && !empty($cmd)) {
            $stmt = $db->prepare("INSERT INTO vm_commands (vm_id, command, status, created_at) VALUES (?, ?, 'pending', ?)");
            $t = now();
            $stmt->bind_param("iss", $vmId, $cmd, $t);
            if ($stmt->execute()) {
                echo json_encode(['success' => true]);
            } else {
                echo json_encode(['success' => false]);
            }
        } else {
            echo json_encode(['success' => false]);
        }
        break;
    
    case 'vm_ping':
        $vmId = (int)($input['vm_id'] ?? 0);
        if ($vmId > 0) {
            $db->query("UPDATE vms SET last_seen = UTC_TIMESTAMP() WHERE id = $vmId");
        }
        echo json_encode(['success'=>true]);
        break;  

case 'load_all':
    $groups = []; 
    $res = $db->query("
        SELECT 
            g.id AS g_id, g.name AS g_name,
            r.id AS r_id, r.name AS r_name,
            v.id AS v_id, v.unit_id, v.current_ip, 
            n.last_heartbeat AS last_seen,
            n.balance, n.traffic, n.status AS node_status
        FROM groups g
        LEFT JOIN rdps r ON g.id = r.group_id
        LEFT JOIN vms v ON r.id = v.rdp_id
        LEFT JOIN earnapp_nodes n ON v.id = n.vm_id
        ORDER BY g.name, r.name, v.unit_id
    ");

    while ($row = $res->fetch_assoc()) {
        $gId = $row['g_id'];
        if (!isset($groups[$gId])) {
            $groups[$gId] = ['id' => $gId, 'name' => $row['g_name'], 'rdps' => []];
        }
        if ($row['r_id']) {
            if (!isset($groups[$gId]['rdps'][$row['r_id']])) {
                $groups[$gId]['rdps'][$row['r_id']] = ['id' => $row['r_id'], 'name' => $row['r_name'], 'vms' => []];
            }
            if ($row['v_id']) {
                $groups[$gId]['rdps'][$row['r_id']]['vms'][] = [
                    'id' => (int)$row['v_id'],
                    'name' => $row['unit_id'],
                    'current_ip' => $row['current_ip'],
                    'last_seen' => $row['last_seen'],
                    'balance' => $row['balance'] ?? '$0.00',
                    'traffic' => $row['traffic'] ?? '0B',
                    'db_status' => $row['node_status'] ?? 'offline'
                ];
            }
        }
    }
    $final = [];
    foreach ($groups as $g) {
        $g['rdps'] = array_values($g['rdps']);
        $final[] = $g;
    }
    echo json_encode(['success' => true, 'data' => ['data' => $final, 'server_time' => date('Y-m-d H:i:s')]]);
    break;
    
    
case 'update_balance':
    $stmt = $db->prepare("
        UPDATE earnapp_nodes
        SET balance=?, traffic=?, status=?, last_updated=NOW()
        WHERE vm_id=?
    ");
    $stmt->bind_param(
        "sssi",
        $input['balance'],
        $input['traffic'],
        $input['status'],
        $input['vm_id']
    );
    $stmt->execute();
    echo json_encode(['ok'=>true]);
    break;



case 'register':
    $groupName = $input['group_name'];
    $rdpName   = $input['rdp_nickname'];
    $g = $db->query("SELECT id FROM groups WHERE name='".$db->real_escape_string($groupName)."' LIMIT 1")->fetch_assoc();
    $r = $db->query("SELECT id FROM rdps WHERE name='".$db->real_escape_string($rdpName)."' LIMIT 1")->fetch_assoc();
    if (!$g || !$r) {
        echo json_encode(['error'=>'group_or_rdp_missing']);
        break;
    }
    $stmt = $db->prepare("
        INSERT INTO vms (unit_id, group_id, rdp_id, group_name, rdp_nickname, current_ip, status, last_seen)
        VALUES (?, ?, ?, ?, ?, ?, 'online', UTC_TIMESTAMP())
        ON DUPLICATE KEY UPDATE
        current_ip=VALUES(current_ip),
        status='online',
        last_seen=UTC_TIMESTAMP()
    ");
    $stmt->bind_param("siisss", $input['unit_id'], $g['id'], $r['id'], $groupName, $rdpName, $input['assigned_ip']);
    $stmt->execute();
    echo json_encode(['vm_id' => $db->insert_id]);
    break;

case 'delete_vms':

    $ids = $input['ids'] ?? [];

    if (!is_array($ids) || empty($ids)) {
        echo json_encode(['success'=>false]);
        break;
    }

    $idList = implode(',', array_map('intval', $ids));
    $db->query("DELETE FROM vms WHERE id IN ($idList)");

    echo json_encode(['success'=>true]);
    break;

case 'delete_rdps':

    $ids = $input['ids'] ?? [];

    if (!is_array($ids) || empty($ids)) {
        echo json_encode(['success'=>false]);
        break;
    }

    $idList = implode(',', array_map('intval', $ids));

    $db->query("
        DELETE FROM vms
        WHERE rdp_id IN ($idList)
           OR (rdp_id IS NULL AND rdp_nickname IN (
                SELECT name FROM rdps WHERE id IN ($idList)
              ))
    ");

    $db->query("DELETE FROM rdps WHERE id IN ($idList)");

    echo json_encode(['success'=>true]);
    break;

case 'delete_groups':

    $ids = $input['ids'] ?? [];

    if (!is_array($ids) || empty($ids)) {
        echo json_encode(['success'=>false]);
        break;
    }

    $idList = implode(',', array_map('intval', $ids));

    $db->query("
        DELETE FROM vms
        WHERE group_id IN ($idList)
           OR (group_id IS NULL AND group_name IN (
                SELECT name FROM groups WHERE id IN ($idList)
              ))
    ");

    $db->query("DELETE FROM rdps WHERE group_id IN ($idList)");
    $db->query("DELETE FROM groups WHERE id IN ($idList)");

    echo json_encode(['success'=>true]);
    break;

case 'heartbeat':
    if (empty($input['vm_id'])) {
        echo json_encode(['success'=>false]);
        break;
    }
    $vmId = (int)$input['vm_id'];
    $ip   = $input['ip_address'] ?? null;
    $db->query("
        UPDATE vms 
        SET last_seen = UTC_TIMESTAMP(), 
            current_ip = " . ($ip ? "'" . $db->real_escape_string($ip) . "'" : "current_ip") . "
        WHERE id = $vmId
    ");
    echo json_encode(['success'=>true]);
    break;



case 'ack_command':

    $id    = (int)($_GET['id'] ?? 0);
    $vm_id = (int)($_GET['vm_id'] ?? 0);

    if ($id <= 0 || $vm_id <= 0) {
        echo json_encode(['error'=>'invalid_params']);
        break;
    }

    $stmt = $db->prepare("
        UPDATE vm_commands
        SET status='done', completed_at=NOW()
        WHERE id=? AND vm_id=?
    ");

    $stmt->bind_param("ii", $id, $vm_id);
    $stmt->execute();

    echo json_encode(['ok'=>true]);
    break;

case 'get_commands':

    $vmId = (int)($_GET['vm_id'] ?? 0);
    $cmds = [];

    $res = $db->query("
        SELECT id, command FROM vm_commands
        WHERE vm_id=$vmId AND status='pending'
    ");

    while ($r = $res->fetch_assoc()) {
        $cmds[] = $r;
    }

    echo json_encode(['commands'=>$cmds]);
    break;

case 'send_command':

    $cmd  = strtolower($input['command']);
    $vmId = (int)$input['vm_id'];

    if ($cmd === 'restart_vm') {
        $db->query("UPDATE vm_commands SET status='done' WHERE vm_id=$vmId AND status='pending'");
    }

    $stmt = $db->prepare("
        INSERT INTO vm_commands (vm_id, command, status, created_at)
        VALUES (?, ?, 'pending', ?)
    ");

    $stmt->bind_param("iss", $vmId, $cmd, now());
    $stmt->execute();

    echo json_encode(['success'=>true]);
    break;

case 'command_result':

    $stmt = $db->prepare("
        UPDATE vm_commands
        SET status='done',
            result=CONCAT('[', ?, '] ', ?),
            completed_at=?
        WHERE id=?
    ");

    $success = $input['success'] ? 'OK' : 'FAIL';

    $stmt->bind_param(
        "sssi",
        $success,
        $input['message'],
        now(),
        $input['command_id']
    );

    $stmt->execute();
    echo json_encode(['ok'=>true]);
    break;

case 'add_group':

    $stmt = $db->prepare("INSERT INTO groups (name) VALUES (?)");
    $stmt->bind_param("s", $input['name']);
    $stmt->execute();
    echo json_encode(['success'=>true]);
    break;

case 'add_rdp':

    $stmt = $db->prepare("
        INSERT INTO rdps (name, group_id, ip, username)
        VALUES (?, ?, ?, ?)
    ");

    $stmt->bind_param(
        "siss",
        $input['name'],
        $input['group_id'],
        $input['ip'],
        $input['username']
    );

    $stmt->execute();
    echo json_encode(['success'=>true]);
    break;

case 'add_vm':

    $rdpId = (int)$input['rdp_id'];

    $r = $db->query("SELECT name, group_id FROM rdps WHERE id=$rdpId")->fetch_assoc();
    $g = $db->query("SELECT name FROM groups WHERE id=".$r['group_id'])->fetch_assoc();

    if (!$r || !$g) {
        echo json_encode(['success'=>false]);
        break;
    }

    $stmt = $db->prepare("
        INSERT INTO vms (unit_id, group_id, rdp_id, group_name, rdp_nickname, status)
VALUES (?, ?, ?, ?, ?, 'offline')
    ");

    $stmt->bind_param(
        "siiss",
        $input['name'],
        $r['group_id'],
        $rdpId,
        $g['name'],
        $r['name']
    );

    $stmt->execute();
    echo json_encode(['success'=>true]);
    break;
    
    

default:
    echo json_encode(['error'=>'invalid_action']);
}

$db->close();
