<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

require_once __DIR__ . '/../db.php';

$username = $_SESSION['username'] ?? 'Guest';
$avatar = '';
if (!empty($_SESSION['user_id'])) {
    $stmt = $conn->prepare("SELECT avatar FROM users WHERE id = ? LIMIT 1");
    $stmt->bind_param("i", $_SESSION['user_id']);
    $stmt->execute();
    $row = $stmt->get_result()->fetch_assoc();
    $avatar = $row['avatar'] ?? '';
}
$avatarUrl = $avatar ? "/earnapp/uploads/avatars/".$avatar : "/earnapp/assets/img/default-avatar.png";

$stats = [];

$res = $conn->query("SELECT COUNT(*) as total FROM earnapp_nodes");
$stats['total_vms'] = $res->fetch_assoc()['total'] ?? 0;

$res = $conn->query("SELECT COUNT(*) as online FROM earnapp_nodes WHERE last_heartbeat >= DATE_SUB(NOW(), INTERVAL 30 MINUTE)");
$stats['online_vms'] = $res->fetch_assoc()['online'] ?? 0;

$res = $conn->query("SELECT COUNT(*) as blocked FROM earnapp_nodes WHERE status LIKE '%Blocked%' OR status LIKE '%Blacklist%'");
$stats['anomalies'] = $res->fetch_assoc()['blocked'] ?? 0;

$stats['offline_vms'] = max(0, $stats['total_vms'] - $stats['online_vms']);

$sql_today = "SELECT SUM(diff) as total FROM (
    SELECT (MAX(CAST(REPLACE(balance, '$', '') AS DECIMAL(10,2))) - MIN(CAST(REPLACE(balance, '$', '') AS DECIMAL(10,2)))) as diff 
    FROM earnapp_history 
    WHERE DATE(recorded_at) = CURDATE() 
    GROUP BY vm_id
) as t";
$stats['earning_today'] = $conn->query($sql_today)->fetch_assoc()['total'] ?? 0;

$sql_month = "SELECT SUM(diff) as total FROM (
    SELECT (MAX(CAST(REPLACE(balance, '$', '') AS DECIMAL(10,2))) - MIN(CAST(REPLACE(balance, '$', '') AS DECIMAL(10,2)))) as diff 
    FROM earnapp_history 
    WHERE MONTH(recorded_at) = MONTH(CURDATE()) AND YEAR(recorded_at) = YEAR(CURDATE()) 
    GROUP BY vm_id
) as m";
$stats['earning_month'] = $conn->query($sql_month)->fetch_assoc()['total'] ?? 0;

$res_all = $conn->query("SELECT SUM(CAST(REPLACE(balance, '$', '') AS DECIMAL(10,2))) as total FROM earnapp_nodes");
$stats['earning_alltime'] = $res_all->fetch_assoc()['total'] ?? 0;
?>

<header class="topbar">
    <div class="user-box">
        <div class="avatar" style="background-image:url('<?= htmlspecialchars($avatarUrl) ?>')"></div>
        <div>
            <div class="username"><?= htmlspecialchars($username) ?></div>
        </div>
    </div>
    <div class="brand-title">BDMA APP</div>
</header>

<div class="container-fluid px-4 py-3 text-white">
  <div class="row g-2 mb-3">
    <div class="col-xl-3 col-md-6">
      <div class="stat-box d-flex align-items-center bg-dark p-3 rounded shadow-sm border-start border-danger border-4">
        <i class="fa fa-desktop fs-4 me-3 text-danger"></i>
        <div>
          <h2 class="m-0 fs-4"><?= $stats['total_vms'] ?></h2>
          <small class="text-uppercase text-muted" style="font-size: 10px;">Total VMs</small>
        </div>
      </div>
    </div>
    <div class="col-xl-3 col-md-6">
      <div class="stat-box d-flex align-items-center bg-dark p-3 rounded shadow-sm border-start border-success border-4">
        <i class="fa fa-circle-check fs-4 me-3 text-success"></i>
        <div>
          <h2 class="m-0 fs-4"><?= $stats['online_vms'] ?></h2>
          <small class="text-uppercase text-muted" style="font-size: 10px;">Online</small>
        </div>
      </div>
    </div>
    <div class="col-xl-3 col-md-6">
      <div class="stat-box d-flex align-items-center bg-dark p-3 rounded shadow-sm border-start border-secondary border-4">
        <i class="fa fa-clock fs-4 me-3 text-secondary"></i>
        <div>
          <h2 class="m-0 fs-4"><?= $stats['offline_vms'] ?></h2>
          <small class="text-uppercase text-muted" style="font-size: 10px;">Offline</small>
        </div>
      </div>
    </div>
    <div class="col-xl-3 col-md-6">
      <div class="stat-box d-flex align-items-center bg-dark p-3 rounded shadow-sm border-start border-warning border-4">
        <i class="fa fa-triangle-exclamation fs-4 me-3 text-warning"></i>
        <div>
          <h2 class="m-0 fs-4"><?= $stats['anomalies'] ?></h2>
          <small class="text-uppercase text-muted" style="font-size: 10px;">Anomalies</small>
        </div>
      </div>
    </div>
  </div>
  
  <div class="row g-2 mb-3">
    <div class="col-xl-4 col-md-6">
      <div class="stat-box d-flex align-items-center bg-dark p-3 rounded shadow-sm border-start border-success border-4">
        <i class="fa fa-dollar-sign fs-4 me-3 text-success"></i>
        <div>
          <h2 class="m-0 fs-4">$<?= number_format($stats['earning_today'], 2) ?></h2>
          <small class="text-uppercase text-muted" style="font-size: 10px;">Today Earning</small>
        </div>
      </div>
    </div>
    <div class="col-xl-4 col-md-6">
      <div class="stat-box d-flex align-items-center bg-dark p-3 rounded shadow-sm border-start border-warning border-4">
        <i class="fa fa-coins fs-4 me-3 text-warning"></i>
        <div>
          <h2 class="m-0 fs-4">$<?= number_format($stats['earning_month'], 2) ?></h2>
          <small class="text-uppercase text-muted" style="font-size: 10px;">This Month</small>
        </div>
      </div>
    </div>
    <div class="col-xl-4 col-md-12">
      <div class="stat-box d-flex align-items-center bg-dark p-3 rounded shadow-sm border-start border-danger border-4">
        <i class="fa fa-vault fs-4 me-3 text-danger"></i>
        <div>
          <h2 class="m-0 fs-4">$<?= number_format($stats['earning_alltime'], 2) ?></h2>
          <small class="text-uppercase text-muted" style="font-size: 10px;">All Time Earning</small>
        </div>
      </div>
    </div>
  </div>
</div>