<?php
require_once __DIR__ . '/../db.php';

$res = $conn->query("SELECT COUNT(*) AS c FROM vms");
$stats['total_vms'] = (int)$res->fetch_assoc()['c'];

$res = $conn->query("
    SELECT COUNT(*) AS c
    FROM vms
    WHERE last_heartbeat IS NOT NULL
      AND last_heartbeat >= UTC_TIMESTAMP() - INTERVAL 5 MINUTE
");
$stats['online_vms'] = (int)$res->fetch_assoc()['c'];

$res = $conn->query("
    SELECT COUNT(*) AS c
    FROM vms
    WHERE last_heartbeat IS NULL
       OR last_heartbeat < UTC_TIMESTAMP() - INTERVAL 5 MINUTE
");
$stats['offline_vms'] = (int)$res->fetch_assoc()['c'];


$res = $conn->query("
    SELECT IFNULL(SUM(balance),0) AS c
    FROM vms
");
$stats['earning_today'] = (float)$res->fetch_assoc()['c'];

$res = $conn->query("
    SELECT IFNULL(SUM(balance),0) AS c
    FROM vms
");
$stats['earning_month'] = (float)$res->fetch_assoc()['c'];


$tree = [];
$data_res = $conn->query("
    SELECT 
        g.id AS g_id,
        g.name AS g_name,
        r.id AS r_id,
        r.name AS r_name,
        v.id AS v_id,
        v.unit_id,
        v.current_ip,
        v.last_heartbeat, 
        v.status,
        COALESCE(v.balance, 0) AS balance,
        v.traffic,
        v.earnapp_token
    FROM groups g
    LEFT JOIN rdps r ON g.id = r.group_id
    LEFT JOIN vms v ON r.id = v.rdp_id
    ORDER BY g.name ASC, r.name ASC, v.unit_id ASC
");

if ($data_res) {
    while($row = $data_res->fetch_assoc()){
        $gid = $row['g_id']; 
        $rid = $row['r_id'];
        
        if(!$gid) continue;
        
        if(!isset($tree[$gid])) {
            $tree[$gid] = ['id'=>$gid, 'name'=>$row['g_name'], 'rdps'=>[]];
        }
        
        if($rid) {
            if(!isset($tree[$gid]['rdps'][$rid])) {
                $tree[$gid]['rdps'][$rid] = ['id'=>$rid, 'name'=>$row['r_name'], 'vms'=>[]];
            }
            
            if($row['v_id'] !== null){
                $tree[$gid]['rdps'][$rid]['vms'][] = $row;
            }
        }
    }
}

$jsGroupData = [];
foreach($tree as $g) {
    $rdps = [];
    if(isset($g['rdps'])){
        foreach($g['rdps'] as $r) {
            $rdps[] = ['id' => $r['id'], 'name' => $r['name']];
        }
    }
    $jsGroupData[] = ['id' => $g['id'], 'name' => $g['name'], 'rdps' => $rdps];
}



?>

<script>
    window.groupData = <?php echo json_encode($jsGroupData); ?>;
</script>
<div class="container-fluid px-4 py-3">
    <div class="row mb-4">
        <div class="col-md-3"><div class="card bg-dark text-white p-3 border-danger text-center"><h6>Total VMs</h6><h3><?= $stats['total_vms'] ?></h3></div></div>
        <div class="col-md-3"><div class="card bg-dark text-white p-3 border-success text-center"><h6>Online</h6><h3><?= $stats['online_vms'] ?></h3></div></div>
        <div class="col-md-3"><div class="card bg-dark text-white p-3 border-warning text-center"><h6>Today</h6><h3>$<?= number_format($stats['earning_today'], 2) ?></h3></div></div>
        <div class="col-md-3"><div class="card bg-dark text-white p-3 border-info text-center"><h6>This Month</h6><h3>$<?= number_format($stats['earning_month'], 2) ?></h3></div></div>
    </div>

    <div class="row mb-3">
        <div class="col-md-6">
            <input id="searchInput" class="form-control bg-dark text-white border-secondary" placeholder="Search..." onkeyup="app.search()">
        </div>
        <div class="col-md-6 text-end">
            <button class="btn btn-danger btn-sm" onclick="app.openModal('group')">+ GROUP</button>
            <button class="btn btn-danger btn-sm" onclick="app.openModal('rdp')">+ RDP</button>
            <button class="btn btn-danger btn-sm" onclick="app.openModal('vm')">+ VM</button>
        </div>
    </div>

    <div class="row">
        <div class="col-md-3">
            <div class="card bg-dark text-white border-secondary">
                <div class="card-header">Navigator</div>
               <div class="list-group list-group-flush small nav-tree">

                    <?php foreach ($tree as $g): ?>
                      <div class="nav-group">
                    
                        <div class="nav-group-title" onclick="toggleGroup(this)">
                          <?= $g['name'] ?>
                        </div>
                    
                        <div class="nav-group-body">
                          <?php foreach ($g['rdps'] as $r): ?>
                            <div class="nav-rdp">
                    
                              <div class="nav-rdp-title" onclick="toggleRdp(this)">
                                RDP: <?= $r['name'] ?>
                              </div>
                    
                              <div class="nav-rdp-body">
                                  <?php foreach ($r['vms'] as $v): ?>
                                    <a href="#vm-card-<?= $v['v_id'] ?>" class="nav-vm">
                                      <?= htmlspecialchars($v['unit_id']) ?>
                                    </a>
                                  <?php endforeach; ?>
                                </div>
                    
                            </div>
                          <?php endforeach; ?>
                        </div>
                    
                      </div>
                    <?php endforeach; ?>
                    
                    </div>

            </div>
        </div>

        <div class="col-md-9">
            <div class="mb-3">
                <button class="btn btn-outline-danger btn-sm" onclick="app.bulkDelete('vm')">Delete VMs</button>
                <button class="btn btn-outline-danger btn-sm" onclick="app.bulkDelete('rdp')">Delete RDPs</button>
                <button class="btn btn-outline-danger btn-sm" onclick="app.bulkDelete('group')">Delete Groups</button>
            </div>

             <div id="mainContent">

<?php foreach ($tree as $g): ?>

<?php
$groupVmTotal = 0;
$groupVmOffline = 0;
$groupVmPending = 0;

foreach ($g['rdps'] as $r) {
    foreach ($r['vms'] as $v) {
        $groupVmTotal++;
        if (empty($v['last_heartbeat'])) {
            $groupVmPending++;
        } elseif (strtotime($v['last_heartbeat']) < strtotime('-5 minutes')) {
            $groupVmOffline++;
        }
    }
}
?>

<div class="group-box mb-4 p-3 border border-secondary rounded bg-dark shadow searchable-item"
     data-name="<?= $g['name'] ?>" id="g-<?= $g['id'] ?>">
    
    <?php $groupCount = 1;
$rdpCount = count($g['rdps']);
$vmCount = 0;

foreach ($g['rdps'] as $r) {
    $vmCount += count($r['vms']);
}?>

  <div class="grp-header grp-toggle" onclick="toggleMainGroup(this)">
    <div class="grp-left">
      <input type="checkbox" class="group-check me-2" value="<?= $g['id'] ?>">
      <span class="grp-name"><?= $g['name'] ?></span>
    </div>
    <div class="grp-right">
      <span class="dot green"><?= $groupCount ?></span>
      <span class="dot red"><?= $rdpCount ?></span>
      <span class="dot yellow"><?= $vmCount ?></span>
    </div>
  </div>

  <div class="grp-body" style="display:none">
    <?php foreach ($g['rdps'] as $r): ?>
    <div class="rdp-box ms-3 mt-3 searchable-item" data-name="<?= $r['name'] ?>">
      <h6 class="text-info">
        <input type="checkbox" class="rdp-check me-2" value="<?= $r['id'] ?>">
        RDP: <?= $r['name'] ?>
      </h6>

      <div class="row">

<?php foreach ($r['vms'] as $v): ?>

<?php

$dbStatus = strtolower(trim($v['status'] ?? ''));

/* VM heartbeat status */
$isVmOnline = (
    !empty($v['last_heartbeat']) &&
    strtotime($v['last_heartbeat']) >= strtotime('-5 minutes')
);

$isOnline = $isVmOnline;

/* EarnApp running status */
$isEarnRunning = (
    $isVmOnline &&
    strpos($dbStatus, 'blocked') === false
);

/* BLOCKED priority */
if (strpos($dbStatus, 'blocked') !== false) {

    $statusText  = 'BLOCKED';
    $statusSub   = 'RESOURCE BLOCKED';
    $statusClass = 'off';

    $runningTxt = 'BLOCKED';
    $runningCls = 'bad';

} else {

    /* VM badge only from heartbeat */
    if ($isVmOnline) {
        $statusText  = 'ONLINE';
        $statusSub   = 'VM ALIVE';
        $statusClass = 'on';
    } else {
        $statusText  = 'OFFLINE';
        $statusSub   = 'VM OFFLINE';
        $statusClass = 'off';
    }

    /* EarnApp running flag only */
    if ($isEarnRunning) {
        $runningTxt = 'RUNNING';
        $runningCls = 'ok';
    } else {
        $runningTxt = 'OFFLINE';
        $runningCls = 'bad';
    }
}

/* AUTO / PAUSED */
$isAuto   = true;
$autoTxt  = $isAuto ? 'ON' : 'OFF';
$autoCls  = $isAuto ? 'ok' : 'bad';

$isPaused  = ($dbStatus === 'paused');
$pausedTxt = $isPaused ? 'YES' : 'NO';
$pausedCls = $isPaused ? 'bad' : 'ok';

/* OTHER */
$balanceTxt = '$' . number_format((float)$v['balance'], 2);

$earnappLink = !empty($v['earnapp_token'])
    ? 'https://earnapp.com/dashboard/link/sdk-win-' . $v['earnapp_token']
    : null;

$lastSeenTxt = !empty($v['last_heartbeat'])
    ? date('j/n/Y, g:i:s A', strtotime($v['last_heartbeat']))
    : 'Never';

?>



<div class="col-12 vm-row searchable-item"
     data-name="<?= $v['unit_id'] ?>"
     id="vm-card-<?= $v['v_id'] ?>">
    
    
    <input type="checkbox"
       class="vm-check"
       value="<?= $v['v_id'] ?>"
       style="margin-right:10px"> VM

  <div class="ea-card">

    <div class="ea-left">
      <div class="ea-status <?= $statusClass ?>">
        <?= $statusText ?>
        <?php if(!$isOnline): ?><small><?= $statusSub ?></small><?php endif; ?>
    </div>
    
    <?php
$hbTxt = 'No heartbeat';

if (!empty($v['last_heartbeat'])) {
    $hbTs = strtotime($v['last_heartbeat']);
    $now  = strtotime(gmdate('Y-m-d H:i:s'));
    $diff = abs($now - $hbTs);

    if ($diff < 60) {
        $hbTxt = $diff . ' sec ago';
    } elseif ($diff < 3600) {
        $hbTxt = floor($diff / 60) . ' min ago';
    } elseif ($diff < 86400) {
        $hbTxt = floor($diff / 3600) . ' hours ago';
    } else {
        $hbTxt = floor($diff / 86400) . ' days ago';
    }
}
?>

<div class="ea-left-meta">
    <div class="ea-vm"><?= $v['unit_id'] ?></div>

    <div class="ea-ip">
        <i class="fas fa-wifi"></i> <?= $v['current_ip'] ?: 'No IP' ?>
    </div>

    <div class="ea-hb" style="margin-top:4px;font-size:12px;color:#aaa">
        <i class="fas fa-heartbeat" style="color: var(--primary-color);"></i>
       <?= !empty($v['last_heartbeat'])
    ? date('H:i:s', strtotime($v['last_heartbeat']))
    : 'No heartbeat' ?>

    </div>
</div>


    </div>

    <div class="ea-center">
      <div class="ea-token-box" style="display:none">
          <?php if($earnappLink): ?>
            <span class="ea-token-text"
                  onclick="app.copyText('<?= $earnappLink ?>')">
              <?= $earnappLink ?>
            </span>
            <small style="margin-left:6px;color:#888">(click to copy)</small>
          <?php else: ?>
            No token yet
          <?php endif; ?>
        </div>

      <div class="ea-flags">
        <span>Running: <b class="<?= $runningCls ?>"><?= $runningTxt ?></b></span>
        <span>Auto: <b class="<?= $autoCls ?>"><?= $autoTxt ?></b></span>
        <span>Paused: <b class="<?= $pausedCls ?>"><?= $pausedTxt ?></b></span>
      </div>

      <div class="ea-sync">Sync: <?= $lastSeenTxt ?></div>
      <div class="ea-balance">Balance: <b><?= $balanceTxt ?></b></div>
    </div>

    <div class="ea-right">
        <button class="ea-btn" onclick="app.openModal('vm')">+ VM</button>
      <button class="ea-btn" onclick="toggleToken(this)">
          <i class="fa fa-key"></i> Token
        </button>
      <button class="ea-btn" onclick="app.restartVm(<?= $v['v_id'] ?>)">
          <i class="fa fa-power-off"></i> Restart
        </button>
      <button id="fetch-btn-<?= $v['v_id'] ?>" class="ea-btn" onclick="app.fetchBalance(<?= $v['v_id'] ?>)"> <i class="fa fa-dollar-sign"></i> Fetch Balance </button>
      <button class="ea-btn"
        onclick="app.openTerminal(<?= htmlspecialchars(json_encode($v)) ?>,'<?= $r['name'] ?>','<?= $g['name'] ?>')">
        <i class="fa fa-terminal"></i> Terminal
      </button>
    </div>

  </div>
</div>

<?php endforeach; ?>

</div>
      </div>
    </div>
  <?php endforeach; ?>

</div>

<?php endforeach; ?>

</div>  
            </div>
        </div>
    </div>
</div>

<div id="overlay" onclick="app.closeModal()"></div>
<?php include __DIR__.'/../modals/group.php'; ?>
<?php include __DIR__.'/../modals/rdp.php'; ?>
<?php include __DIR__.'/../modals/vm.php'; ?>

<div id="terminalModal" class="modal">
  <div class="modal-content bg-dark text-white border-danger" style="max-width:800px; width:95%">
    <div class="modal-header border-secondary">
      <h5 class="modal-title"><i class="fa fa-terminal me-2"></i> <span id="termTitle">Terminal</span></h5>
      <button class="btn-close btn-close-white" onclick="app.closeModal()"></button>
    </div>
    <div class="modal-body">
      <div class="mb-3 small p-2 bg-black border border-secondary rounded d-flex justify-content-around">
          <span>VM ID: <b id="termVmId"></b></span>
          <span>Group: <b id="termGroup"></b></span>
          <span>RDP: <b id="termRdp"></b></span>
      </div>
      
      <div class="mb-3">
        <label class="small text-muted">Install Command (PowerShell)</label>
        <div class="input-group">
          <input id="installCmd" class="form-control bg-black text-success small" readonly>
          <button class="btn btn-danger btn-sm" onclick="app.copy('installCmd')">Copy</button>
        </div>
      </div>

      <div class="mb-3">
        <label class="small text-muted">Uninstall Command</label>
        <div class="input-group">
          <input id="uninstallCmdInput" class="form-control bg-black text-white" readonly>
          <button class="btn btn-danger btn-sm" onclick="app.copy('uninstallCmdInput')">Copy</button>
        </div>
      </div>

    </div>
  </div>
</div>
<style>
#overlay{position:fixed;top:0;left:0;width:100%;height:100%;background:rgba(0,0,0,.85);display:none;z-index:9998}
.modal{position:fixed;top:0;left:0;width:100%;height:100%;display:none;justify-content:center;align-items:center;z-index:9999}
.modal-content{animation:modalIn .2s}
@keyframes modalIn{from{transform:scale(.95);opacity:0}to{transform:scale(1);opacity:1}}
.bg-black{background:#000!important}
.searchable-item{transition:all .2s}

.nav-tree a { text-decoration:none }

.nav-group-title{
  padding:10px;
  font-weight:700;
  cursor:pointer;
  background:#1c1f22;
  border-bottom:1px solid #333;
}

.nav-group-body{
  display:none;
}

.nav-rdp-title{
  padding:8px 10px 8px 20px;
  color:#4cc3ff;
  cursor:pointer;
}

.nav-rdp-body{
  display:none;
}

.nav-vm{
  display:block;
  padding:6px 10px 6px 40px;
  font-size:13px;
  color:#aaa;
}
.nav-vm:hover{color:#fff}


.grp-header{
  display:flex;
  justify-content:space-between;
  align-items:center;
  padding:12px 16px;
  background:linear-gradient(90deg,#2a0a3d,#120016);
  border-radius:10px;
  margin-bottom:12px;
}
.grp-name{color:#c77dff;font-weight:700}
.dot{
  width:26px;height:26px;
  display:inline-flex;
  align-items:center;
  justify-content:center;
  border-radius:50%;
  font-size:12px;
  margin-left:6px;
}
.dot.green{background:#063;color:#4cff9a}
.dot.red{background:#300;color:#ff4c4c}
.dot.yellow{background:#332200;color:#ffcc00}


.ea-card{
  display:grid;
  grid-template-columns:180px 1fr 220px;
  gap:24px;
  background:#070707;
  border:1px solid #300;
  border-radius:14px;
  padding:22px;
  margin-top:16px;
}

.ea-left{text-align:center}
.ea-status{
  padding:10px;
  border-radius:10px;
  font-weight:700;
}
.ea-status.on{background:#062;color:#4cff9a}
.ea-status.off{background:#300;color:#ff4c4c}
.ea-status small{display:block;font-size:11px;opacity:.8}

.ea-left-meta{margin-top:14px;font-size:13px;color:#aaa}
.ea-vm{color:#fff;font-weight:600;margin-bottom:4px}

.ea-center{padding-top:6px}

.ea-token-box{
  color:#ff4c4c;
  font-size:14px;
  word-break:break-all;
}
.ea-token-box span{
  color:#4cff9a;
  font-size:12px;
  cursor:pointer;
  margin-left:8px;
}

.ea-flags{
  display:flex;
  gap:18px;
  margin-top:10px;
  font-size:14px;
}

.ok{color:#4cff9a}
.bad{color:#ff4c4c}

.ea-sync{
  margin-top:8px;
  font-size:13px;
  color:#aaa;
}

.ea-right{
  display:flex;
  flex-direction:column;
  gap:14px;
  justify-content:center;
}

.ea-btn{
  display:flex;
  align-items:center;
  justify-content:center;
  gap:8px;
  background:#0b0b0b;
  border:1px solid #400;
  color:#fff;
  padding:14px;
  border-radius:10px;
  font-size:15px;
}
.ea-btn i{color:#ff4c4c}
.ea-btn:hover{border-color:#f33}
.ea-balance{
  margin-top:6px;
  font-size:13px;
  color:#4cff9a;
}

/* navigator header base */
.card-header{
  display:flex;
  align-items:center;
  justify-content:space-between;
  position:relative;
  overflow:hidden;
}

/* arrow button */
.card-header::after{
  content:"";
  width:28px;
  height:28px;
  border-radius:6px;
  border:1px solid #3a0f52;
  background:#120016;
  box-shadow:0 0 8px rgba(199,125,255,.4);
  background-image:url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24' fill='none' stroke='%23c77dff' stroke-width='2' stroke-linecap='round' stroke-linejoin='round'%3E%3Cpolyline points='15 18 9 12 15 6'/%3E%3C/svg%3E");
  background-repeat:no-repeat;
  background-position:center;
  transition:.25s;
}
/* navigator base */
.col-md-3:has(.nav-tree){
  transition:all .3s;
  overflow:hidden;
}

/* collapsed sidebar */
.col-md-3:has(.nav-tree).nav-collapsed{
  width:64px;
  max-width:64px;
  flex:0 0 64px;
  padding:0;
  overflow:hidden;
}

/* header */
.col-md-3:has(.nav-tree).nav-collapsed .card-header{
  position:relative;
  display:flex;
  align-items:center;
  justify-content:center;
  color:transparent;   /* 🔑 text hide, pseudo safe */
}

/* GRID ICON */
.col-md-3:has(.nav-tree).nav-collapsed .card-header::before{
  content:"";
  position:absolute;
  left:14px;
  width:24px;
  height:24px;
   background-repeat:no-repeat;
  background-position:center;
  background-size:contain;
}

/* ARROW */
.col-md-3:has(.nav-tree).nav-collapsed .card-header::after{
  content:"";
  position:absolute;
  right:10px;
  width:26px;
  height:26px;
  border-radius:6px;
  border:1px solid #3a0f52;
  background:#120016;
  box-shadow:0 0 8px rgba(199,125,255,.4);
  background-image:url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24' fill='none' stroke='%23c77dff' stroke-width='2' stroke-linecap='round' stroke-linejoin='round'%3E%3Cpolyline points='15 18 9 12 15 6'/%3E%3C/svg%3E");
  background-repeat:no-repeat;
  background-position:center;
  transform:rotate(180deg);
}

/* hide tree fully */
.col-md-3:has(.nav-tree).nav-collapsed .nav-tree{
  display:none !important;
}

/* right side full */
.col-md-3:has(.nav-tree).nav-collapsed ~ .col-md-9{
  width:100%;
  max-width:100%;
  flex:0 0 100%;
}

/* mobile */
@media (max-width:768px){
  .col-md-3:has(.nav-tree){
    position:fixed;
    left:0;
    top:0;
    height:100%;
    z-index:1000;
    background:#000;
    transform:translateX(-100%);
    transition:.3s;
  }
  .col-md-3:has(.nav-tree).nav-open{
    transform:translateX(0);
  }
}


</style>

<script>
window.app = {
    async api(action, data = {}) {
        try {
            const r = await fetch('pages/api.php', {
                method: 'POST',
                headers: {'Content-Type': 'application/json'},
                body: JSON.stringify({action, ...data})
            });
            const text = await r.text();
            if (!text) return {success: false};
            return JSON.parse(text);
        } catch (e) {
            console.error(e);
            return {success: false};
        }
    },

    copyText(text) {
        const ta = document.createElement('textarea');
        ta.value = text;
        ta.style.position = 'fixed';
        ta.style.opacity = '0';
        document.body.appendChild(ta);
        ta.focus();
        ta.select();
        document.execCommand('copy');
        document.body.removeChild(ta);
    },

    search() {
        const term = document.getElementById('searchInput').value.toLowerCase().trim();
    
        document.querySelectorAll('.group-box').forEach(group => {
            let groupMatch = false;
    
            group.querySelectorAll('.vm-row').forEach(vm => {
                const unit = vm.getAttribute('data-name').toLowerCase();
    
                if (!term || unit.includes(term)) {
                    vm.style.display = '';
                    groupMatch = true;
    
                    const grpBody = group.querySelector('.grp-body');
                    if (grpBody) grpBody.style.display = 'block';
                } else {
                    vm.style.display = 'none';
                }
            });
    
            group.style.display = groupMatch || !term ? '' : 'none';
        });
    },

    openModal(type) {
        document.getElementById('overlay').style.display = 'block';
        const modal = document.getElementById(type === 'terminal' ? 'terminalModal' : 'modal-' + type);
        if (modal) modal.style.display = 'flex';
    },

    closeModal() {
        document.getElementById('overlay').style.display = 'none';
        document.querySelectorAll('.modal').forEach(m => m.style.display = 'none');
    },

    openTerminal(v, rName, gName) {
        const base = window.location.origin + window.location.pathname.split('/index.php')[0];
        document.getElementById('termTitle').innerText = v.unit_id;
        document.getElementById('termVmId').innerText = v.v_id;
        document.getElementById('termGroup').innerText = gName;
        document.getElementById('termRdp').innerText = rName;

        document.getElementById('installCmd').value =
            'irm "' + base + '/static/install.ps1" -OutFile i.ps1; .\\i.ps1 -VMId ' + v.v_id +
            ' -UnitId "' + v.unit_id + '" -Group "' + gName +
            '" -RdpNickname "' + rName + '" -BackendUrl "' + base + '"';

        const uninst = document.getElementById('uninstallCmdInput');
        if(uninst) uninst.value = 'irm "' + base + '/static/uninstall.ps1" | iex';

        this.openModal('terminal');
    },

    copy(id) {
        const el = document.getElementById(id);
        el.select();
        navigator.clipboard.writeText(el.value);
    },

    filterRdpList(groupId) {
        const rdpSelect = document.getElementById('vmRdpSelect');
        rdpSelect.innerHTML = '<option value="">-- Select RDP --</option>';

        if (!groupId) {
            rdpSelect.innerHTML = '<option value="">-- Select Group First --</option>';
            return;
        }

        const group = window.groupData.find(g => g.id == groupId);

        if (group && group.rdps) {
            group.rdps.forEach(rdp => {
                const opt = document.createElement('option');
                opt.value = rdp.id;
                opt.textContent = rdp.name;
                rdpSelect.appendChild(opt);
            });
        }
    },

    async addVM() {
        const rdpId = document.getElementById('vmRdpSelect').value;
        const unitId = document.getElementById('vmInput').value;

        if (!rdpId || !unitId) {
            alert('Please fill all fields');
            return;
        }

        const res = await this.api('add_vm', {
            rdp_id: rdpId,
            unit_id: unitId
        });

        if (res && res.success) {
            location.reload();
        } else {
            alert('Failed to add VM');
        }
    },

    async restartVm(vmId) {
        if (!confirm('Restart this VM?')) return;
        const res = await this.api('send_command', {
            vm_id: parseInt(vmId),
            command: 'restart_vm'
        });
        if (res && res.success) alert('Command sent');
        else alert('Failed');
    },

    async fetchBalance(vmId) {
        const btn = document.getElementById('fetch-btn-' + vmId);
        if (btn) btn.disabled = true;
    
        const res = await this.api('send_command', {
            vm_id: parseInt(vmId),
            command: 'fetch_balance'
        });
    
        if (res && res.success) alert('Request sent');
        else alert('Failed');
    
        setTimeout(() => { if (btn) btn.disabled = false; }, 3000);
    },

    async bulkDelete(type) {
        const ids = [...document.querySelectorAll('.' + type + '-check:checked')].map(c => c.value);
        if(!ids.length || !confirm('Delete ' + ids.length + ' items?')) return;
        await this.api('delete_' + type + 's', {ids});
        location.reload();
    }
};

window.toggleMainGroup = function(el) {
    const body = el.nextElementSibling;
    if(!body) return;
    body.style.display = (body.style.display === 'block') ? 'none' : 'block';
};

window.toggleGroup = function(el) {
    const body = el.nextElementSibling;
    if(body) body.style.display = (body.style.display === 'block') ? 'none' : 'block';
};

window.toggleRdp = function(el) {
    const body = el.nextElementSibling;
    if(body) body.style.display = (body.style.display === 'block') ? 'none' : 'block';
};

window.toggleToken = function(btn) {
    const box = btn.closest('.ea-card').querySelector('.ea-token-box');
    if(box) box.style.display = (box.style.display === 'none') ? 'block' : 'none';
};
</script>

<script>
(function(){
  const nav = document.querySelector('.col-md-3:has(.nav-tree)');
  const header = nav.querySelector('.card-header');

  header.addEventListener('click', e => {
    const rect = header.getBoundingClientRect();
    if (e.clientX < rect.right - 40) return;

    if (window.innerWidth <= 768) {
      nav.classList.toggle('nav-open');
    } else {
      nav.classList.toggle('nav-collapsed');
    }
  });
})();
</script>

