<?php
if (!isset($conn)) { require_once __DIR__ . '/../db.php'; }

date_default_timezone_set('Asia/Kolkata');

// 1. Determine User Groups (if not already set)
if (!isset($gidList)) {
    $uid_stat       = currentUserId();
    $admin_stat     = isAdmin();
    $groupIds_stat  = getUserGroupIds($conn, $uid_stat, $admin_stat);
    if (empty($groupIds_stat)) { $groupIds_stat = [0]; }
    $gidList        = implode(',', $groupIds_stat);
}

// 2. Prepare Token List for Historical Queries
$tok_arr_stat = [];
$res_tok = $conn->query("SELECT v.earnapp_token FROM vms v JOIN rdps r ON r.id=v.rdp_id WHERE r.group_id IN ($gidList) AND v.earnapp_token IS NOT NULL AND v.earnapp_token != ''");
if ($res_tok) {
    while($row = $res_tok->fetch_assoc()) {
        $tok_arr_stat[] = "'" . $conn->real_escape_string($row['earnapp_token']) . "'";
    }
}
$statTokList = empty($tok_arr_stat) ? "''" : implode(',', $tok_arr_stat);

// 3. Total VMs
$res = $conn->query("SELECT COUNT(*) AS c FROM vms v JOIN rdps r ON r.id=v.rdp_id WHERE r.group_id IN ($gidList)");
$stats['total_vms'] = (int)($res ? $res->fetch_assoc()['c'] : 0);

// 4. Online VMs (Heartbeat check)
$res = $conn->query("SELECT COUNT(*) AS c FROM vms v JOIN rdps r ON r.id=v.rdp_id WHERE r.group_id IN ($gidList) AND v.last_heartbeat >= NOW() - INTERVAL 5 MINUTE");
$stats['online_vms'] = (int)($res ? $res->fetch_assoc()['c'] : 0);

// 5. Offline VMs
$res = $conn->query("SELECT COUNT(*) AS c FROM vms v JOIN rdps r ON r.id=v.rdp_id WHERE r.group_id IN ($gidList) AND (v.last_heartbeat IS NULL OR v.last_heartbeat < NOW() - INTERVAL 5 MINUTE)");
$stats['offline_vms'] = (int)($res ? $res->fetch_assoc()['c'] : 0);

// 6. App Status Counts (CORRECTED: Only count status if VM is ONLINE)
$app_running = $app_paused = $app_blocked = 0;
$res = $conn->query("
    SELECT LOWER(v.status) AS status, COUNT(*) AS c 
    FROM vms v 
    JOIN rdps r ON r.id=v.rdp_id 
    WHERE r.group_id IN ($gidList) 
    AND v.last_heartbeat >= NOW() - INTERVAL 5 MINUTE 
    GROUP BY LOWER(v.status)
");
if ($res) {
    while ($r = $res->fetch_assoc()) {
        $st = trim($r['status']);
        // Categorize strict status
        if (strpos($st, 'running') !== false) {
            $app_running += (int)$r['c'];
        } elseif (strpos($st, 'blocked') !== false || strpos($st, 'banned') !== false) {
            $app_blocked += (int)$r['c'];
        } else {
            // Paused, Stopped, etc.
            $app_paused += (int)$r['c'];
        }
    }
}

$today_res = $conn->query("
    SELECT IFNULL(SUM(diff),0) AS total
    FROM (
        SELECT 
            earnapp_token,
            redeem_balance - LAG(redeem_balance) OVER (
                PARTITION BY earnapp_token 
                ORDER BY recorded_at
            ) AS diff,
            earning_date
        FROM earnapp_history
        WHERE earnapp_token IN ($statTokList)
    ) t
    WHERE earning_date = CURDATE()
    AND diff > 0
");
$stats['earning_today'] = (float)($today_res ? $today_res->fetch_assoc()['total'] : 0);

// 8. Earning Yesterday
$yesterday_res = $conn->query("
    SELECT IFNULL(SUM(GREATEST(0, y.yest_max - IFNULL(p.prev_max, 0))), 0) AS total
    FROM (
        SELECT earnapp_token, MAX(COALESCE(redeem_balance, CAST(balance AS DECIMAL(10,4)))) AS yest_max
        FROM earnapp_history WHERE DATE(recorded_at)=CURDATE()-INTERVAL 1 DAY AND earnapp_token IN ($statTokList)
        GROUP BY earnapp_token
    ) y
    LEFT JOIN (
        SELECT earnapp_token, MAX(COALESCE(redeem_balance, CAST(balance AS DECIMAL(10,4)))) AS prev_max
        FROM earnapp_history WHERE DATE(recorded_at)=CURDATE()-INTERVAL 2 DAY AND earnapp_token IN ($statTokList)
        GROUP BY earnapp_token
    ) p ON p.earnapp_token=y.earnapp_token
");
$stats['earning_yesterday'] = (float)($yesterday_res ? $yesterday_res->fetch_assoc()['total'] : 0);

// 9. Earning Week
$week_res = $conn->query("
    SELECT IFNULL(SUM(daily_earned), 0) AS total
    FROM (
        SELECT t.earnapp_token, GREATEST(0, t.day_max - IFNULL(p.prev_day_max, 0)) AS daily_earned
        FROM (
            SELECT earnapp_token, DATE(recorded_at) AS dt, MAX(COALESCE(redeem_balance, CAST(balance AS DECIMAL(10,4)))) AS day_max
            FROM earnapp_history WHERE DATE(recorded_at) BETWEEN CURDATE()-INTERVAL 6 DAY AND CURDATE() AND earnapp_token IN ($statTokList)
            GROUP BY earnapp_token, DATE(recorded_at)
        ) t
        LEFT JOIN (
            SELECT earnapp_token, DATE(recorded_at) AS dt, MAX(COALESCE(redeem_balance, CAST(balance AS DECIMAL(10,4)))) AS prev_day_max
            FROM earnapp_history WHERE earnapp_token IN ($statTokList) GROUP BY earnapp_token, DATE(recorded_at)
        ) p ON p.earnapp_token=t.earnapp_token AND p.dt=DATE_SUB(t.dt, INTERVAL 1 DAY)
    ) x
");
$stats['earning_week'] = (float)($week_res ? $week_res->fetch_assoc()['total'] : 0);

// 10. Earning Month
$month_start = date('Y-m-01');
$month_res = $conn->query("
    SELECT IFNULL(SUM(daily_earned), 0) AS total
    FROM (
        SELECT t.earnapp_token, GREATEST(0, t.day_max - IFNULL(p.prev_day_max, 0)) AS daily_earned
        FROM (
            SELECT earnapp_token, DATE(recorded_at) AS dt, MAX(COALESCE(redeem_balance, CAST(balance AS DECIMAL(10,4)))) AS day_max
            FROM earnapp_history WHERE DATE(recorded_at) BETWEEN '$month_start' AND CURDATE() AND earnapp_token IN ($statTokList)
            GROUP BY earnapp_token, DATE(recorded_at)
        ) t
        LEFT JOIN (
            SELECT earnapp_token, DATE(recorded_at) AS dt, MAX(COALESCE(redeem_balance, CAST(balance AS DECIMAL(10,4)))) AS prev_day_max
            FROM earnapp_history WHERE earnapp_token IN ($statTokList) GROUP BY earnapp_token, DATE(recorded_at)
        ) p ON p.earnapp_token=t.earnapp_token AND p.dt=DATE_SUB(t.dt, INTERVAL 1 DAY)
    ) x
");
$stats['earning_month'] = (float)($month_res ? $month_res->fetch_assoc()['total'] : 0);
?>

<style>
.stat-tile{background:#0b0c10;border-radius:12px;padding:14px 16px;border-left:3px solid transparent;display:flex;flex-direction:column;gap:4px;min-width:0;transition:transform .2s;}
.stat-tile:hover{transform:translateY(-2px);}
.st-icon{font-size:18px;margin-bottom:4px;}
.st-value{font-size:22px;font-weight:700;color:#fff;line-height:1;}
.st-label{font-size:11px;color:#888;text-transform:uppercase;letter-spacing:.5px;}
</style>

<div class="row mb-3 g-2">
    <div class="col-6 col-md-3 col-xl">
        <div class="stat-tile" style="border-color:#9b4dff">
            <div class="st-icon" style="color:#9b4dff"><i class="fa fa-desktop"></i></div>
            <div class="st-value"><?= $stats['total_vms'] ?></div>
            <div class="st-label">Total VMs</div>
        </div>
    </div>
    <div class="col-6 col-md-3 col-xl">
        <div class="stat-tile" style="border-color:#00e5ff">
            <div class="st-icon" style="color:#00e5ff"><i class="fa fa-wifi"></i></div>
            <div class="st-value"><?= $stats['online_vms'] ?></div>
            <div class="st-label">Online</div>
        </div>
    </div>
    <div class="col-6 col-md-3 col-xl">
        <div class="stat-tile" style="border-color:#00ff66">
            <div class="st-icon" style="color:#00ff66"><i class="fa fa-play"></i></div>
            <div class="st-value"><?= $app_running ?></div>
            <div class="st-label">Running</div>
        </div>
    </div>
    <div class="col-6 col-md-3 col-xl">
        <div class="stat-tile" style="border-color:#ffb300">
            <div class="st-icon" style="color:#ffb300"><i class="fa fa-pause"></i></div>
            <div class="st-value"><?= $app_paused ?></div>
            <div class="st-label">Paused</div>
        </div>
    </div>
    <div class="col-6 col-md-3 col-xl">
        <div class="stat-tile" style="border-color:#ff003c">
            <div class="st-icon" style="color:#ff003c"><i class="fa fa-ban"></i></div>
            <div class="st-value"><?= $app_blocked ?></div>
            <div class="st-label">Blocked</div>
        </div>
    </div>
    <div class="col-6 col-md-3 col-xl">
        <div class="stat-tile" style="border-color:#ffb300">
            <div class="st-icon" style="color:#ffb300"><i class="fa fa-dollar-sign"></i></div>
            <div class="st-value">$<?= number_format($stats['earning_today'], 2) ?></div>
            <div class="st-label">Today</div>
        </div>
    </div>
    <div class="col-6 col-md-3 col-xl">
        <div class="stat-tile" style="border-color:#888">
            <div class="st-icon" style="color:#888"><i class="fa fa-calendar-day"></i></div>
            <div class="st-value">$<?= number_format($stats['earning_yesterday'], 2) ?></div>
            <div class="st-label">Yesterday</div>
        </div>
    </div>
    <div class="col-6 col-md-3 col-xl">
        <div class="stat-tile" style="border-color:#00e5ff">
            <div class="st-icon" style="color:#00e5ff"><i class="fa fa-calendar-week"></i></div>
            <div class="st-value">$<?= number_format($stats['earning_week'], 2) ?></div>
            <div class="st-label">This Week</div>
        </div>
    </div>
    <div class="col-6 col-md-3 col-xl">
        <div class="stat-tile" style="border-color:#9b4dff">
            <div class="st-icon" style="color:#9b4dff"><i class="fa fa-calendar"></i></div>
            <div class="st-value">$<?= number_format($stats['earning_month'], 2) ?></div>
            <div class="st-label">This Month</div>
        </div>
    </div>
</div>