<?php
if (!function_exists('isAdmin')) { require_once __DIR__ . '/../db.php'; }

date_default_timezone_set('Asia/Kolkata');

$uid       = currentUserId();
$admin     = isAdmin();
$groupIds  = getUserGroupIds($conn, $uid, $admin);
$gidList   = implode(',', $groupIds);
$_vd       = getVmData($conn);
$_tokList  = $_vd['tokenList'];
$_vmIdList = $_vd['vmIdList'];

// -- Sync Logic (DB Updates) --
$vms_sync = $conn->query("
    SELECT v.earnapp_token, v.balance, v.status, v.current_ip AS ip_address
    FROM vms v JOIN rdps r ON r.id=v.rdp_id
    WHERE r.group_id IN ($gidList)
");
if ($vms_sync) {
    while ($row = $vms_sync->fetch_assoc()) {
        $token = $row['earnapp_token'];
        if (empty($token)) continue;
        $current_balance = (float)$row['balance'];
        $stmt_last = $conn->prepare("SELECT COALESCE(redeem_balance, CAST(balance AS DECIMAL(10,4))) AS eff_balance FROM earnapp_history WHERE earnapp_token=? ORDER BY recorded_at DESC LIMIT 1");
        $stmt_last->bind_param("s", $token);
        $stmt_last->execute();
        $stmt_last->bind_result($prev_bal_val);
        $last_row_found = $stmt_last->fetch();
        $stmt_last->close();
        $previous_balance = $last_row_found ? (float)$prev_bal_val : -1;
        if ($previous_balance >= 0 && abs($current_balance - $previous_balance) < 0.0001) continue;
        $stmt_insert = $conn->prepare("INSERT INTO earnapp_history (earnapp_token, ip_address, redeem_balance, cashout_detected, status, earning_date, recorded_at) VALUES (?, ?, ?, 0, ?, CURDATE(), NOW())");
        $stmt_insert->bind_param("ssds", $token, $row['ip_address'], $current_balance, $row['status']);
        $stmt_insert->execute();
        $stmt_insert->close();
    }
}

// -- Build Data Tree for Navigator --
$tree = [];
$data_res = $conn->query("
    SELECT g.id AS g_id, g.name AS g_name,
           r.id AS r_id, r.name AS r_name,
           v.id AS v_id, v.unit_id, v.current_ip, v.last_heartbeat, v.status,
           CASE WHEN v.last_heartbeat IS NOT NULL AND v.last_heartbeat >= NOW()-INTERVAL 5 MINUTE THEN 1 ELSE 0 END AS is_online,
           COALESCE(v.balance,0) AS balance,
           v.traffic, v.earnapp_token
    FROM `groups` g
    LEFT JOIN rdps r ON g.id=r.group_id
    LEFT JOIN vms v ON r.id=v.rdp_id
    WHERE g.id IN ($gidList)
    ORDER BY g.name ASC, r.name ASC, v.unit_id ASC
");
if ($data_res) {
    while ($row = $data_res->fetch_assoc()) {
        $gid = $row['g_id'];
        $rid = $row['r_id'];
        if (!$gid) continue;
        if (!isset($tree[$gid])) $tree[$gid] = ['id' => $gid, 'name' => $row['g_name'], 'rdps' => []];
        if ($rid) {
            if (!isset($tree[$gid]['rdps'][$rid])) $tree[$gid]['rdps'][$rid] = ['id' => $rid, 'name' => $row['r_name'], 'vms' => []];
            if ($row['v_id'] !== null) $tree[$gid]['rdps'][$rid]['vms'][] = $row;
        }
    }
}

$jsGroupData = [];
foreach ($tree as $g) {
    $rdps = [];
    foreach ($g['rdps'] as $r) $rdps[] = ['id' => $r['id'], 'name' => $r['name']];
    $jsGroupData[] = ['id' => $g['id'], 'name' => $g['name'], 'rdps' => $rdps];
}
?>

<div class="container-fluid px-4 py-3">

<?php include __DIR__ . '/../parts/vm_top_stats.php'; ?>

<div class="d-flex align-items-center gap-2 mb-3 flex-wrap">
    <input id="searchInput" class="form-control flex-fill" style="background:#0b0c10;color:#fff;border:1px solid rgba(255,255,255,.15);border-radius:8px;max-width:300px;" placeholder="Search VMs, groups..." onkeyup="app.search()">
    <div class="ms-auto d-flex gap-2 flex-wrap">
        <?php if ($admin): ?>
        <button class="ea-ibtn1" title="Toggle Telegram" onclick="toggleTelegram()"><i class="fa fa-bell" id="tgIcon"></i></button>
        <?php endif; ?>
        <button class="ea-ibtn1" title="Restart All" onclick="app.restartAllVms()"><i class="fa fa-power-off"></i></button>
        <button class="ea-ibtn1" title="Fetch All Balances" onclick="app.fetchAllBalances()"><i class="fa fa-dollar-sign"></i></button>
        <button class="ea-ibtn1" title="Add Group" onclick="app.openModal('group')"><i class="fa fa-folder"></i></button>
        <button class="ea-ibtn1" title="Add RDP" onclick="app.openModal('rdp')"><i class="fa fa-server"></i></button>
        <button class="ea-ibtn1" title="Add VM" onclick="app.openModal('vm')"><i class="fa fa-desktop"></i></button>
    </div>
</div>

<script>window.groupData = <?= json_encode($jsGroupData) ?>;</script>

<div class="row">
    <div class="col-md-3 nav-col">
        <div class="card bg-dark text-white border-secondary nav-full">
            <div class="card-header nav-header"><span>Navigator</span><i class="fa fa-chevron-left nav-toggle-icon" onclick="toggleNavigator()"></i></div>
            <div class="list-group list-group-flush small nav-tree">
                <?php foreach ($tree as $g): ?>
                <div class="nav-group">
                    <div class="nav-group-title" onclick="toggleGroup(this)"><?= htmlspecialchars($g['name']) ?></div>
                    <div class="nav-group-body">
                        <?php foreach ($g['rdps'] as $r): ?>
                        <div class="nav-rdp">
                            <div class="nav-rdp-title" onclick="toggleRdp(this)">RDP: <?= htmlspecialchars($r['name']) ?></div>
                            <div class="nav-rdp-body">
                                <?php foreach ($r['vms'] as $v): ?>
                                <a href="#vm-card-<?= $v['v_id'] ?>" class="nav-vm"><?= htmlspecialchars($v['unit_id']) ?></a>
                                <?php endforeach; ?>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>

    <div class="col-md-9 main-col">
        <div id="mainContent">

<?php foreach ($tree as $g):
    $rdpCount = count($g['rdps']);
    $vmCount  = 0;
    foreach ($g['rdps'] as $r) $vmCount += count($r['vms']);
    $gTotalBal = 0;
    foreach ($g['rdps'] as $r) foreach ($r['vms'] as $v) $gTotalBal += (float)$v['balance'];
?>

<div class="group-box mb-4 p-3 border border-secondary rounded bg-dark shadow searchable-item" data-name="<?= htmlspecialchars($g['name']) ?>" id="g-<?= $g['id'] ?>">
    <div class="grp-header" onclick="grpToggle(<?= $g['id'] ?>)">
        <div class="grp-left">
            <i class="fa fa-chevron-right grp-chevron" id="gc-<?= $g['id'] ?>"></i>
            <span class="grp-name"><?= htmlspecialchars($g['name']) ?></span>
            <span class="badge ms-2" style="background:rgba(0,255,102,.1);color:#00ff66;border:1px solid rgba(0,255,102,.3);font-size:11px;border-radius:20px;">$<?= number_format($gTotalBal, 2) ?></span>
        </div>
        <div class="grp-icons">
            <span class="dot green"><?= $rdpCount ?></span>
            <span class="dot yellow"><?= $vmCount ?></span>
            <button class="grp-ibtn" onclick="event.stopPropagation();app.openRdpFromGroup(<?= $g['id'] ?>)"><i class="fa fa-server"></i></button>
            <button class="grp-ibtn" onclick="event.stopPropagation();app.openVmFromGroup(<?= $g['id'] ?>)"><i class="fa fa-desktop"></i></button>
            <?php if ($admin): ?>
            <button class="grp-ibtn danger" onclick="event.stopPropagation();app.deleteGroup(<?= $g['id'] ?>)"><i class="fa fa-trash"></i></button>
            <?php endif; ?>
        </div>
    </div>

    <div id="gb-<?= $g['id'] ?>" style="display:none;margin-top:10px;">
        <?php foreach ($g['rdps'] as $r):
            $rdpId     = (int)$r['id'];
            $rdpTotal  = count($r['vms']);
            $rdpOnline = 0;
            $rdpBal    = 0;
            foreach ($r['vms'] as $v) {
                if ((int)$v['is_online'] === 1) $rdpOnline++;
                $rdpBal += (float)$v['balance'];
            }
        ?>
        <div class="rdp-box searchable-item" data-name="<?= htmlspecialchars($r['name']) ?>">
            <div class="rdp-header" onclick="rdpToggle(<?= $rdpId ?>)">
                <div class="rdp-header-left">
                    <i class="fa fa-chevron-right rdp-chevron" id="rc-<?= $rdpId ?>"></i>
                    <span class="rdp-title-text"><?= htmlspecialchars($r['name']) ?></span>
                </div>
                <div class="rdp-meta">
                    <span class="rdp-earning-badge">$<?= number_format($rdpBal, 2) ?></span>
                    <span style="color:#4ecb71"><?= $rdpOnline ?> online</span>
                    <span>/</span>
                    <span><?= $rdpTotal ?> VMs</span>
                    <button class="grp-ibtn" onclick="event.stopPropagation();app.openVmFromRdp(<?= $g['id'] ?>,<?= $rdpId ?>)"><i class="fa fa-plus"></i></button>
                </div>
            </div>

            <div class="rdp-body" id="rb-<?= $rdpId ?>">
                <div class="row">
<?php foreach ($r['vms'] as $v):
    $statusRaw   = strtolower(trim($v['status'] ?? 'unknown'));
    $isOnline    = ((int)$v['is_online'] === 1);
    $statusText  = $isOnline ? 'ONLINE' : 'OFFLINE';
    $statusClass = $isOnline ? 'on' : 'off';
    $statusColor = 'ok';
    if ($statusRaw==='blocked' || $statusRaw==='offline') $statusColor = 'bad';
    elseif ($statusRaw==='paused') $statusColor = 'warn';
    $earnappLink = !empty($v['earnapp_token']) ? 'https://earnapp.com/dashboard/link/sdk-win-' . $v['earnapp_token'] : null;
    $lastSeenTxt = !empty($v['last_heartbeat']) ? date('j/n/Y, g:i:s A', strtotime($v['last_heartbeat'])) : 'Never';
    $hbDisplay   = !empty($v['last_heartbeat']) ? date('H:i:s', strtotime($v['last_heartbeat'])) : 'No heartbeat';
?>
<div class="col-12 searchable-item" data-name="<?= htmlspecialchars($v['unit_id']) ?>" id="vm-card-<?= $v['v_id'] ?>">
    <div class="ea-card">
        <div class="ea-left">
            <div class="ea-status <?= $statusClass ?>">
                <?= $statusText ?>
                <?php if (!$isOnline): ?><small>OFFLINE</small><?php endif; ?>
            </div>
            <div class="ea-left-meta">
                <div class="ea-vm"><?= htmlspecialchars($v['unit_id']) ?></div>
                <div class="ea-ip"><?= htmlspecialchars($v['current_ip'] ?: 'No IP') ?></div>
                <div class="ea-hb" style="margin-top:4px;font-size:11px;color:#aaa"><?= $hbDisplay ?></div>
            </div>
        </div>
        <div class="ea-center">
            <div class="ea-token-box" style="display:none;margin-top:5px;">
                <?php if ($earnappLink): ?>
                    <div class="d-flex align-items-center bg-dark border border-secondary rounded p-1">
                        <span class="small text-white text-truncate me-2" style="flex:1;word-break:break-all;white-space:normal;line-height:1.2;"><?= htmlspecialchars($earnappLink) ?></span>
                        <button class="btn btn-sm btn-outline-secondary py-0 px-2" style="font-size:12px;" onclick="app.copyText('<?= htmlspecialchars($earnappLink) ?>')"><i class="fa fa-copy"></i></button>
                    </div>
                <?php else: ?><small class="text-muted">No token yet</small><?php endif; ?>
            </div>
            <div class="ea-flags">
                <span>Status:
                    <?php if (!$isOnline): ?>
                        <b style="color:#dc3545">OFFLINE</b>
                    <?php else: ?>
                        <b class="<?= $statusColor ?>"><?= strtoupper($statusRaw) ?></b>
                    <?php endif; ?>
                </span>
            </div>
            <div class="ea-sync">Sync: <?= $lastSeenTxt ?></div>
            <div class="ea-balance">Balance: <b>$<?= number_format((float)$v['balance'], 2) ?></b></div>
        </div>
        <div class="ea-right ea-icon-strip">
            <button class="ea-btn" title="Token" onclick="toggleToken(this)"><i class="fa fa-key"></i></button>
            <button class="ea-btn" title="Restart" onclick="app.restartVm(<?= $v['v_id'] ?>)"><i class="fa fa-power-off"></i></button>
            <button id="fetch-btn-<?= $v['v_id'] ?>" class="ea-btn" title="Fetch Balance" onclick="app.fetchBalance(<?= $v['v_id'] ?>)"><i class="fa fa-dollar-sign"></i></button>
            <button class="ea-btn" title="Terminal" onclick="app.openTerminal(<?= htmlspecialchars(json_encode($v)) ?>,'<?= addslashes($r['name']) ?>','<?= addslashes($g['name']) ?>')"><i class="fa fa-terminal"></i></button>
            <button class="ea-btn danger" onclick="app.deleteVm(<?= $v['v_id'] ?>)"><i class="fa fa-trash"></i></button>
        </div>
    </div>
</div>
<?php endforeach; ?>
                </div>
            </div>
        </div>
        <?php endforeach; ?>
    </div>
</div>
<?php endforeach; ?>

        </div>
    </div>
</div>
</div>

<div id="overlay" onclick="app.closeModal()"></div>
<?php include __DIR__.'/../modals/group.php'; ?>
<?php include __DIR__.'/../modals/rdp.php'; ?>
<?php include __DIR__.'/../modals/vm.php'; ?>

<div id="terminalModal" class="modal">
  <div class="modal-content bg-dark text-white border-danger" style="max-width:800px;width:95%">
    <div class="modal-header border-secondary">
      <h5 class="modal-title"><i class="fa fa-terminal me-2"></i><span id="termTitle">Terminal</span></h5>
      <button class="btn-close btn-close-white" onclick="app.closeModal()"></button>
    </div>
    <div class="modal-body">
      <div class="mb-3 small p-2 bg-black border border-secondary rounded d-flex justify-content-around">
          <span>VM ID: <b id="termVmId"></b></span>
          <span>Group: <b id="termGroup"></b></span>
          <span>RDP: <b id="termRdp"></b></span>
      </div>
      <div class="mb-3">
        <label class="small text-muted">Install Command (PowerShell)</label>
        <div class="input-group">
          <input id="installCmd" class="form-control bg-black text-success small" readonly>
          <button class="btn btn-danger btn-sm" onclick="app.copy('installCmd')">Copy</button>
        </div>
      </div>
      <div class="mb-3">
        <label class="small text-muted">Uninstall Command</label>
        <div class="input-group">
          <input id="uninstallCmdInput" class="form-control bg-black text-white" readonly>
          <button class="btn btn-danger btn-sm" onclick="app.copy('uninstallCmdInput')">Copy</button>
        </div>
      </div>
    </div>
  </div>
</div>

<style>

.ea-token-text{word-break:break-all;overflow-wrap:anywhere;white-space:normal;}
.grp-header{display:flex;align-items:center;justify-content:space-between;cursor:pointer;padding:8px 10px;border-radius:6px;user-select:none;gap:10px;}
.grp-header:hover{background:rgba(255,255,255,.04);}
.grp-left{display:flex;align-items:center;gap:8px;flex:1;min-width:0;}
.grp-name{font-weight:600;font-size:15px;white-space:nowrap;overflow:hidden;text-overflow:ellipsis;}
.grp-chevron{font-size:11px;color:#888;flex-shrink:0;transition:transform .2s ease;}
.grp-chevron.open{transform:rotate(90deg);}
.grp-icons{display:flex;align-items:center;gap:6px;flex-shrink:0;}
.rdp-box{background:rgba(255,255,255,.03);border:1px solid rgba(255,255,255,.08);border-radius:8px;margin-bottom:12px;overflow:hidden;}
.rdp-header{display:flex;align-items:center;justify-content:space-between;padding:8px 14px;cursor:pointer;background:rgba(255,255,255,.04);user-select:none;gap:10px;}
.rdp-header:hover{background:rgba(255,255,255,.07);}
.rdp-header-left{display:flex;align-items:center;gap:8px;flex:1;}
.rdp-title-text{font-size:13px;font-weight:600;color:#ccc;}
.rdp-chevron{font-size:10px;color:#666;transition:transform .2s ease;}
.rdp-chevron.open{transform:rotate(90deg);}
.rdp-earning-badge{background:rgba(40,200,100,.15);border:1px solid rgba(40,200,100,.3);color:#4ecb71;font-size:11px;font-weight:700;padding:2px 8px;border-radius:20px;}
.rdp-meta{display:flex;align-items:center;gap:8px;color:#888;font-size:11px;flex-shrink:0;}
.rdp-body{padding:10px 12px 12px;display:none;}
.rdp-body.open{display:block;}
</style>

<script>
function toggleTelegram() {
    fetch('/earnapp/toggle_telegram.php', {method:'POST'})
        .then(r => r.text()).then(t => {
            t = t.trim();
            const icon = document.getElementById('tgIcon');
            if (t==='ON') { icon.className='fa fa-bell'; }
            else if (t==='OFF') { icon.className='fa fa-bell-slash'; }
        });
}

window.app = {
    async api(action, data={}) {
        try {
            const r = await fetch('pages/api.php?action=' + action, {
                method:'POST',
                headers:{'Content-Type':'application/json'},
                body:JSON.stringify(data)
            });
            try { return await r.json(); }
            catch(e) { return {success:false,error:'Invalid JSON'}; }
        } catch(e) { return {success:false,error:'Network error'}; }
    },

    notify(msg, ok=true) {
        const el = document.createElement('div');
        el.textContent = msg;
        el.style.cssText = `position:fixed;top:20px;right:20px;z-index:99999;padding:12px 20px;border-radius:10px;font-weight:600;font-size:14px;${ok?'background:rgba(0,255,102,.2);color:#00ff66;border:1px solid rgba(0,255,102,.4)':'background:rgba(255,0,60,.2);color:#ff003c;border:1px solid rgba(255,0,60,.4)'}`;
        document.body.appendChild(el);
        setTimeout(() => el.remove(), 3000);
    },

    copyText(text) {
        navigator.clipboard.writeText(text).catch(() => {
            const ta = document.createElement('textarea');
            ta.value = text;
            ta.style.cssText = 'position:fixed;opacity:0';
            document.body.appendChild(ta);
            ta.select();
            document.execCommand('copy');
            document.body.removeChild(ta);
        });
    },

    search() {
        const term = document.getElementById('searchInput').value.toLowerCase().trim();
        document.querySelectorAll('.group-box').forEach(group => {
            let groupMatch = false;
            group.querySelectorAll('.searchable-item[id^="vm-card"]').forEach(vm => {
                const name = (vm.getAttribute('data-name')||'').toLowerCase();
                const show = !term || name.includes(term);
                vm.style.display = show ? '' : 'none';
                if (show) {
                    groupMatch = true;
                    if (term) {
                        const rb = vm.closest('[id^="rb-"]');
                        if (rb) { rb.classList.add('open'); const rc=document.getElementById('rc-'+rb.id.replace('rb-','')); if(rc) rc.classList.add('open'); }
                        const gb = vm.closest('[id^="gb-"]');
                        if (gb) { gb.style.display='block'; const gc=document.getElementById('gc-'+gb.id.replace('gb-','')); if(gc) gc.classList.add('open'); }
                    }
                }
            });
            group.style.display = groupMatch || !term ? '' : 'none';
        });
    },

    openModal(type) {
        document.getElementById('overlay').style.display = 'block';
        const modal = document.getElementById(type==='terminal' ? 'terminalModal' : 'modal-' + type);
        if (modal) modal.style.display = 'flex';
    },

    closeModal() {
        document.getElementById('overlay').style.display = 'none';
        document.querySelectorAll('.modal').forEach(m => m.style.display = 'none');
        ['vmInput','rdpInput','groupInput'].forEach(id => { const el=document.getElementById(id); if(el) el.value=''; });
    },

    openTerminal(v, rName, gName) {
        const base = window.location.origin + window.location.pathname.split('/index.php')[0];
        document.getElementById('termTitle').innerText = v.unit_id;
        document.getElementById('termVmId').innerText = v.v_id;
        document.getElementById('termGroup').innerText = gName;
        document.getElementById('termRdp').innerText = rName;
        document.getElementById('installCmd').value = `irm "${base}/static/install.ps1" -OutFile i.ps1; .\\i.ps1 -VMId ${v.v_id} -UnitId "${v.unit_id}" -Group "${gName}" -RdpNickname "${rName}" -BackendUrl "${base}"`;
        const uninst = document.getElementById('uninstallCmdInput');
        if (uninst) uninst.value = `irm "${base}/static/uninstall.ps1" | iex`;
        this.openModal('terminal');
    },

    copy(id) { const el=document.getElementById(id); el.select(); navigator.clipboard.writeText(el.value); },

    filterRdpList(groupId, preselectRdpId) {
        const rdpSelect = document.getElementById('vmRdpSelect');
        rdpSelect.innerHTML = '<option value="">-- Select RDP --</option>';
        if (!groupId) return;
        const group = window.groupData.find(g => g.id == groupId);
        if (!group||!group.rdps||!group.rdps.length) return;
        group.rdps.forEach((rdp, i) => {
            const opt = document.createElement('option');
            opt.value = rdp.id; opt.textContent = rdp.name;
            rdpSelect.appendChild(opt);
            if (preselectRdpId && rdp.id==preselectRdpId) rdpSelect.value = rdp.id;
            else if (!preselectRdpId && i===0) rdpSelect.value = rdp.id;
        });
    },

    async addVM() {
        const rdpId  = document.getElementById('vmRdpSelect').value;
        const unitId = document.getElementById('vmInput').value.trim();
        if (!rdpId || !unitId) { alert('Please fill all fields'); return; }
        const btn = document.querySelector('#modal-vm .btn-danger');
        if (btn) { if (btn.dataset.submitting==='true') return; btn.dataset.submitting='true'; btn.disabled=true; }
        const res = await this.api('add_vm', {rdp_id:rdpId, unit_id:unitId});
        if (btn) { btn.dataset.submitting='false'; btn.disabled=false; }
        if (res&&res.success) { this.notify('VM added!'); setTimeout(() => location.reload(), 600); }
        else this.notify(res?.error||'Failed', false);
    },

    async restartAllVms() {
        if (!confirm('Restart all VMs?')) return;
        const res = await this.api('send_global_command', {command:'restart_vm'});
        this.notify(res&&res.success ? 'Restart command sent!' : 'Failed', res&&res.success);
    },

    async fetchAllBalances() {
        const res = await this.api('send_global_command', {command:'fetch_balance'});
        this.notify(res&&res.success ? 'Fetch sent to all VMs!' : 'Failed', res&&res.success);
    },

    async restartVm(vmId) {
        if (!confirm('Restart this VM?')) return;
        const res = await this.api('send_command', {vm_id:parseInt(vmId), command:'restart_vm'});
        this.notify(res&&res.success ? 'Command sent!' : 'Failed', res&&res.success);
    },

    async fetchBalance(vmId) {
        const btn = document.getElementById('fetch-btn-'+vmId);
        if (btn) btn.disabled = true;
        const res = await this.api('send_command', {vm_id:parseInt(vmId), command:'fetch_balance'});
        this.notify(res&&res.success ? 'Request sent!' : 'Failed', res&&res.success);
        setTimeout(() => { if (btn) btn.disabled=false; }, 3000);
    },

    async deleteGroup(groupId) {
        if (!confirm('Delete this group permanently? All RDPs and VMs inside will also be deleted.')) return;
        const res = await this.api('delete_groups', {ids:[parseInt(groupId)]});
        if (res&&res.success) { this.notify('Group deleted!'); setTimeout(() => location.reload(), 600); }
        else this.notify('Delete failed', false);
    },

    async deleteVm(vmId) {
        if (!confirm('Delete this VM permanently?')) return;
        const res = await this.api('delete_vms', {ids:[parseInt(vmId)]});
        if (res&&res.success) { document.getElementById('vm-card-'+vmId)?.remove(); this.notify('VM deleted!'); }
        else this.notify('Delete failed', false);
    },

    openRdpFromGroup(groupId) {
        document.getElementById('overlay').style.display = 'block';
        const modal = document.getElementById('modal-rdp');
        if (modal) { modal.style.display='flex'; const sel=document.getElementById('rdpGroupSelect'); if(sel) sel.value=groupId; }
    },

    openVmFromGroup(groupId) {
        const vmInput = document.getElementById('vmInput');
        if (vmInput) vmInput.value = '';
        const grpSel = document.getElementById('vmGroupSelect');
        if (grpSel) grpSel.value = String(groupId);
        this.filterRdpList(groupId);
        document.getElementById('overlay').style.display = 'block';
        const modal = document.getElementById('modal-vm');
        if (modal) modal.style.display = 'flex';
    },

    openVmFromRdp(groupId, rdpId) {
        const vmInput = document.getElementById('vmInput');
        if (vmInput) vmInput.value = '';
        const grpSel = document.getElementById('vmGroupSelect');
        if (grpSel) grpSel.value = String(groupId);
        this.filterRdpList(groupId, rdpId);
        document.getElementById('overlay').style.display = 'block';
        const modal = document.getElementById('modal-vm');
        if (modal) modal.style.display = 'flex';
    },

    async addRDP() {
        const name    = document.getElementById('rdpInput').value;
        const groupId = document.getElementById('rdpGroupSelect').value;
        if (!name||!groupId) { alert('Fill all fields'); return; }
        const res = await this.api('add_rdp', {name, group_id:parseInt(groupId)});
        if (res&&res.success) { this.notify('RDP added!'); setTimeout(() => location.reload(), 600); }
        else this.notify('Failed to add RDP', false);
    },

    async addGroup() {
        const name = document.getElementById('groupInput').value;
        if (!name) return alert('Enter group name');
        const res = await this.api('add_group', {name});
        if (res&&res.success) { this.notify('Group added!'); setTimeout(() => location.reload(), 600); }
        else this.notify('Failed', false);
    }
};

window.grpToggle = function(id) {
    const body=document.getElementById('gb-'+id); const icon=document.getElementById('gc-'+id);
    if(!body) return;
    const open=body.style.display==='block';
    body.style.display=open?'none':'block';
    if(icon) icon.classList.toggle('open',!open);
};

window.rdpToggle = function(id) {
    const body=document.getElementById('rb-'+id); const icon=document.getElementById('rc-'+id);
    if(!body) return;
    const isOpen=body.classList.contains('open');
    body.classList.toggle('open',!isOpen);
    if(icon) icon.classList.toggle('open',!isOpen);
};

window.toggleGroup = function(el) { const b=el.nextElementSibling; if(b) b.style.display=(b.style.display==='block')?'none':'block'; };
window.toggleRdp   = function(el) { const b=el.nextElementSibling; if(b) b.style.display=(b.style.display==='block')?'none':'block'; };
window.toggleToken = function(btn) { const box=btn.closest('.ea-card').querySelector('.ea-token-box'); if(box) box.style.display=(box.style.display==='none')?'block':'none'; };
window.toggleNavigator = function() { document.querySelector('.nav-col').classList.toggle('nav-collapsed'); };
</script>