-- ============================================================
-- User Permissions System - Migration
-- Run this AFTER migration.sql
-- ============================================================

CREATE TABLE IF NOT EXISTS `user_permissions` (
    `id`              int(11)      NOT NULL AUTO_INCREMENT,
    `user_id`         int(11)      NOT NULL,

    -- Group / RDP / VM Management
    `can_view_groups`    tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Can see group list',
    `can_add_group`      tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Can create new groups',
    `can_edit_group`     tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Can rename/edit groups',
    `can_delete_group`   tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Can delete groups',

    `can_view_rdp`       tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Can view RDP list',
    `can_add_rdp`        tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Can add new RDPs',
    `can_edit_rdp`       tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Can edit RDP details',
    `can_delete_rdp`     tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Can delete RDPs',

    `can_view_vm`        tinyint(1) NOT NULL DEFAULT 1 COMMENT 'Can view VMs (own groups)',
    `can_add_vm`         tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Can register new VMs',
    `can_edit_vm`        tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Can edit VM settings',
    `can_delete_vm`      tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Can delete VMs',
    `can_send_commands`  tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Can send remote commands to VMs',

    -- Earnings & Reports
    `can_view_earnings`  tinyint(1) NOT NULL DEFAULT 1 COMMENT 'Can view earnings page',
    `can_view_reports`   tinyint(1) NOT NULL DEFAULT 1 COMMENT 'Can view reports page',
    `can_view_analytics` tinyint(1) NOT NULL DEFAULT 1 COMMENT 'Can view analytics page',
    `can_view_ip`        tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Can view IP analysis page',

    -- Dashboard & Settings
    `can_view_dashboard` tinyint(1) NOT NULL DEFAULT 1 COMMENT 'Can view main dashboard',
    `can_view_settings`  tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Can view settings page',
    `can_change_password`tinyint(1) NOT NULL DEFAULT 1 COMMENT 'Can change own password',

    -- Tokens
    `can_view_tokens`    tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Can view cold tokens page',

    `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
    PRIMARY KEY (`id`),
    UNIQUE KEY `uk_user_permissions` (`user_id`),
    CONSTRAINT `fk_perm_user` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Per-user granular permissions';

-- Admins get a row with all permissions (they bypass checks anyway via isAdmin())
INSERT IGNORE INTO `user_permissions` (
    user_id,
    can_view_groups, can_add_group, can_edit_group, can_delete_group,
    can_view_rdp, can_add_rdp, can_edit_rdp, can_delete_rdp,
    can_view_vm, can_add_vm, can_edit_vm, can_delete_vm, can_send_commands,
    can_view_earnings, can_view_reports, can_view_analytics, can_view_ip,
    can_view_dashboard, can_view_settings, can_change_password, can_view_tokens
)
SELECT id,
    1,1,1,1,
    1,1,1,1,
    1,1,1,1,1,
    1,1,1,1,
    1,1,1,1
FROM users WHERE role = 'admin';
