<?php
require_once __DIR__ . '/../db.php';

$sql = "
INSERT INTO earnapp_history
(vm_id, group_name, rdp_nickname, balance, traffic, ip_address, earnapp_token, recorded_at)
SELECT
    v.id,
    v.group_name,
    v.rdp_nickname,
    v.balance,
    v.traffic,
    v.current_ip,
    v.earnapp_token,
    NOW()
FROM vms v
WHERE NOT EXISTS (
    SELECT 1
    FROM earnapp_history h
    WHERE h.vm_id = v.id
      AND (
            h.balance = v.balance
            AND h.recorded_at >= DATE_SUB(NOW(), INTERVAL 1 HOUR)
          )
)
";

$conn->query($sql);
$conn->close();
