<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

require_once __DIR__ . '/../db.php';

$username = $_SESSION['username'] ?? 'Guest';
$avatarUrl = "/earnapp/assets/img/default-avatar.png";

if (!empty($_SESSION['user_id'])) {
    $stmt = $conn->prepare("SELECT avatar FROM users WHERE id = ? LIMIT 1");
    $stmt->bind_param("i", $_SESSION['user_id']);
    $stmt->execute();
    $row = $stmt->get_result()->fetch_assoc();
    if (!empty($row['avatar'])) {
        $avatarUrl = "/earnapp/uploads/avatars/" . $row['avatar'];
    }
}
?>

<header class="topbar">
    <div class="user-box">
        <div class="avatar" style="background-image:url('<?= htmlspecialchars($avatarUrl) ?>')"></div>
        <div>
            <div class="username"><?= htmlspecialchars($username) ?></div>
        </div>
    </div>
    <div class="brand-title">BDMA APP</div>
</header>
