<?php
header('Content-Type: application/json');
require_once __DIR__ . '/db.php';

$json = file_get_contents('php://input');
$data = json_decode($json, true);

if (!$data || empty($data['vm_id'])) {
    echo json_encode(["status" => "error", "msg" => "vm_id missing"]);
    exit;
}

$vmId  = (int)$data['vm_id'];
$group = trim($data['group_name'] ?? '');
$rdp   = trim($data['rdp_nickname'] ?? '');
$bal   = $data['balance'] ?? null;
$trafRaw = $data['traffic'] ?? '0';
$traf = (float)preg_replace('/[^0-9.]/', '', $trafRaw);
$rawStatus = strtolower(trim($data['status'] ?? ''));

$stat = null;

if ($rawStatus !== '') {
    if (stripos($rawStatus, 'earning income') !== false) {
        $stat = 'Running';
    } elseif (stripos($rawStatus, 'blocked') !== false) {
        $stat = 'Blocked';
    } elseif (stripos($rawStatus, 'pause') !== false) {
        $stat = 'Paused';
    }
}


$token = $data['earnapp_token'] ?? null;
$ip    = $data['ip_address'] ?? $_SERVER['REMOTE_ADDR'];
$isHeartbeat = isset($data['action']) && $data['action'] === 'heartbeat';

$chk = $conn->prepare("SELECT last_heartbeat FROM vms WHERE id = ? LIMIT 1");
$chk->bind_param("i", $vmId);
$chk->execute();
$chk->bind_result($lastHeartbeat);
$exists = $chk->fetch();
$chk->close();

if (!$exists) {
    echo json_encode(["status" => "error", "msg" => "VM not registered"]);
    exit;
}

 

if ($isHeartbeat) {
    $sql = "
        UPDATE vms SET
            current_ip = ?,
            last_heartbeat = NOW()
        WHERE id = ?
    ";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("si", $ip, $vmId);
} else {

    $groupId = null;
    $qg = $conn->prepare("SELECT id FROM groups WHERE name = ? LIMIT 1");
    $qg->bind_param("s", $group);
    $qg->execute();
    $qg->bind_result($groupId);
    $qg->fetch();
    $qg->close();

    if (!$groupId) {
        echo json_encode(["status" => "error", "msg" => "Invalid group"]);
        exit;
    }

    $rdpId = null;
    $qr = $conn->prepare("SELECT id FROM rdps WHERE name = ? AND group_id = ? LIMIT 1");
    $qr->bind_param("si", $rdp, $groupId);
    $qr->execute();
    $qr->bind_result($rdpId);
    $qr->fetch();
    $qr->close();

    if (!$rdpId) {
        echo json_encode(["status" => "error", "msg" => "Invalid RDP for group"]);
        exit;
    }

    if ($stat !== null) {
    if ($bal !== null && $bal !== '') {
        $sql = "
            UPDATE vms SET
                balance = ?,
                traffic = ?,
                status = ?,
                earnapp_token = ?,
                current_ip = ?,
                last_heartbeat = NOW()
            WHERE id = ?
        ";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("ddsssi", $bal, $traf, $stat, $token, $ip, $vmId);
    } else {
        $sql = "
            UPDATE vms SET
                status = ?,
                traffic = ?,
                earnapp_token = ?,
                current_ip = ?,
                last_heartbeat = NOW()
            WHERE id = ?
        ";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("ssssi", $stat, $traf, $token, $ip, $vmId);
    }

    } else {
        $sql = "
            UPDATE vms SET
                vm_id = unit_id,
                traffic = ?,
                earnapp_token = ?,
                current_ip = ?,
                last_heartbeat = NOW()
            WHERE id = ?
        ";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("sssi", $traf, $token, $ip, $vmId);
    }
}

if ($stmt->execute()) {

    if (!$isHeartbeat) {
        $ins = $conn->prepare("
            INSERT INTO earnapp_history
            (vm_id, group_name, rdp_nickname, balance, ip_address, earnapp_token, status)
            VALUES (?,?,?,?,?,?,?)
        ");
        $balHist = $bal !== null ? $bal : 0;
        $ins->bind_param(
            "sssssss",
            $vmId,
            $group,
            $rdp,
            $balHist,
            $ip,
            $token,
            $stat
        );
        $ins->execute();
        $ins->close();
    }

    echo json_encode(["status" => "success"]);
} else {
    echo json_encode(["status" => "error", "msg" => $stmt->error]);
}

$stmt->close();
$conn->close();
