<?php
if (session_status() === PHP_SESSION_NONE) session_start();
$page = $_GET['page'] ?? 'dashboard';
if (!isset($userPerms)) $userPerms = [];

function showMenu(string $pg, string $icon, string $label, string $perm): void {
    global $page, $userPerms;
    if (!isAdmin() && empty($userPerms[$perm])) return;
    $active = $page === $pg ? 'active' : '';
    echo "<li class=\"$active\"><a href=\"index.php?page=$pg\"><i class=\"fa-solid $icon\"></i> $label</a></li>\n";
}

$role = $_SESSION['role'] ?? 'user';
if ($role === 'super_admin') { $roleLabel = 'SUPER ADMIN'; $roleColor = '#ff7700'; $roleBg = 'rgba(255,119,0,.15)'; }
elseif ($role === 'admin')   { $roleLabel = 'ADMIN';       $roleColor = '#9b4dff'; $roleBg = 'rgba(155,77,255,.15)'; }
else                         { $roleLabel = 'USER';         $roleColor = '#00e5ff'; $roleBg = 'rgba(0,229,255,.1)'; }
?>

<aside class="sidebar open" id="sidebar">
  <div class="logo">
    <i class="fa-solid fa-shield-dog"></i>
    <span>BDMA</span>
  </div>

  <ul class="menu">
    <?php showMenu('dashboard',  'fa-grid',         'Dashboard',   'can_view_dashboard'); ?>
    <?php showMenu('reports',    'fa-table',         'Reports',     'can_view_reports'); ?>
    <?php showMenu('analytics',  'fa-chart-line',    'Analytics',   'can_view_analytics'); ?>
    <?php showMenu('earnings',   'fa-dollar-sign',   'Earnings',    'can_view_earnings'); ?>
    <?php showMenu('ip-analysis','fa-network-wired', 'IP Analysis', 'can_view_ip'); ?>
    <?php showMenu('commands',   'fa-terminal',      'Commands',    'can_send_commands'); ?>
    <?php showMenu('settings','fa-snowflake',     'Settings', 'can_view_settings'); ?>
    <?php if (isSuperAdmin() && !isViewingAs()): ?>
    <li class="<?= $page==='users' ? 'active' : '' ?>">
      <a href="index.php?page=users"><i class="fa-solid fa-users-cog"></i> User Management</a>
    </li>
    <?php endif; ?>
    <?php if (isViewingAs()): ?>
    <li><a href="index.php?view_as=0&page=users" style="color:#ff7700;"><i class="fa-solid fa-right-from-bracket"></i> Exit View</a></li>
    <?php else: ?>
    <li><a href="logout.php"><i class="fa-solid fa-right-from-bracket"></i> Logout</a></li>
    <?php endif; ?>
  </ul>

 
</aside>

<button id="sidebarToggle" class="sidebar-float-btn">
  <i class="fa-solid fa-angle-right"></i>
</button>

<style>
*{box-sizing:border-box;}
html,body{margin:0;padding:0;width:100%;height:100%;overflow-x:hidden;}
.sidebar{position:fixed;top:0;bottom:0;left:0;width:240px;background:#0b0b0b;color:#fff;transform:translateX(-240px);transition:transform .3s ease;z-index:9999;overflow-y:auto;scrollbar-width:none;-ms-overflow-style:none;}
.sidebar::-webkit-scrollbar{display:none;}
.sidebar.open{transform:translateX(0);}
.sidebar .logo{display:flex;align-items:center;gap:10px;padding:16px;font-size:18px;}
.menu{list-style:none;margin:0;padding:0 0 100px;}
.menu li a{display:flex;align-items:center;gap:12px;padding:12px 16px;color:#cfcfcf;text-decoration:none;border-radius:6px;margin:2px 8px;transition:background .15s,color .15s;}
.menu li.active a,.menu li a:hover{background:linear-gradient(90deg,rgba(155,77,255,.25),rgba(155,77,255,.1));color:#fff;border-left:2px solid #9b4dff;}
.sidebar-float-btn{position:fixed;top:50%;left:0;transform:translateY(-50%);width:28px;height:64px;background:#111;color:#9b4dff;border:1px solid #333;border-left:none;border-radius:0 10px 10px 0;cursor:pointer;z-index:10000;transition:left .3s ease;display:flex;align-items:center;justify-content:center;padding:0;}
.sidebar.open ~ .sidebar-float-btn{left:240px;}
.sidebar-float-btn i{transition:transform .3s ease;}
.sidebar.open ~ .sidebar-float-btn i{transform:rotate(180deg);}
.main{margin-left:0;width:100%;min-height:100vh;transition:margin-left .3s ease,width .3s ease;}
.sidebar.open ~ .main{margin-left:240px;width:calc(100% - 240px);}
</style>

<script>
document.getElementById('sidebarToggle').onclick = function() {
    document.getElementById('sidebar').classList.toggle('open');
};
</script>
