<?php
ob_start();
ini_set('display_errors', 0);
error_reporting(E_ALL);

session_start();

if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

if (isset($_SESSION['is_active']) && !$_SESSION['is_active']) {
    session_destroy();
    header('Location: login.php?err=deactivated');
    exit;
}

require_once __DIR__ . '/db.php';
require_once __DIR__ . '/includes/permissions.php';

$activeCheck = $conn->prepare("SELECT is_active, role FROM users WHERE id=? LIMIT 1");
$activeCheck->bind_param("i", $_SESSION['user_id']);
$activeCheck->execute();
$activeCheck->bind_result($isActive, $dbRole);
$activeCheck->fetch();
$activeCheck->close();

if (!$isActive) {
    session_destroy();
    header('Location: login.php?err=deactivated');
    exit;
}

$_SESSION['role'] = $dbRole;

// Load permissions into global $userPerms (used by hasPerm() in all pages)
$userPerms = loadUserPermissions($conn);

$page = $_GET['page'] ?? 'dashboard';

// Admin-only pages (no permission key check, just role)
$adminOnly = ['users'];

// Permission-gated pages: page => required permission key
$permGated = [
    'dashboard'  => 'can_view_dashboard',
    'reports'    => 'can_view_reports',
    'analytics'  => 'can_view_analytics',
    'earnings'   => 'can_view_earnings',
    'ip-analysis'=> 'can_view_ip',
    'commands'   => 'can_send_commands',
    'settings'   => 'can_view_settings',
    'cold-tokens'=> 'can_view_tokens',
    'archive'    => 'can_view_reports',
];

$allAllowed = array_merge(array_keys($permGated), $adminOnly);

// Admin-only page check
if (in_array($page, $adminOnly, true) && !isAdmin()) {
    $page = 'dashboard';
}

// Permission check for non-admin users
if (!isAdmin() && isset($permGated[$page]) && !hasPerm($permGated[$page])) {
    $page = '__denied__';
}

if (!in_array($page, array_merge($allAllowed, ['__denied__']), true)) {
    $page = 'dashboard';
}

$file = __DIR__ . '/pages/' . $page . '.php';

if ($page === '__denied__' || !is_file($file)) {
    $file = null;
}
?>

<?php include __DIR__ . '/includes/head.php'; ?>
<body>

<?php include __DIR__ . '/includes/sidebar.php'; ?>

<div class="main">
    <?php include __DIR__ . '/includes/topbar.php'; ?>
    <?php if ($file): ?>
        <?php include $file; ?>
    <?php else: ?>
        <?php accessDenied(); ?>
    <?php endif; ?>
</div>

<?php include __DIR__ . '/includes/footer.php'; ?>

</body>
</html>
