#Requires -Version 5.1
<#
.SYNOPSIS
    SinnerWatchdog Agent Uninstaller
#>

Write-Host ""
Write-Host "╔══════════════════════════════════════╗" -ForegroundColor Cyan
Write-Host "║   SinnerWatchdog Agent Uninstaller   ║" -ForegroundColor Cyan
Write-Host "╚══════════════════════════════════════╝" -ForegroundColor Cyan
Write-Host ""

$AgentDir = "$env:APPDATA\SinnerWatchdog"
$TaskName = "SinnerWatchdogAgent"
$allOk    = $true

# ── Remove scheduled task ─────────────────────────────────────────────────────
Write-Host "[1/2] Removing scheduled task..." -ForegroundColor Yellow
try {
    $task = Get-ScheduledTask -TaskName $TaskName -ErrorAction SilentlyContinue
    if ($task) {
        Stop-ScheduledTask       -TaskName $TaskName -ErrorAction SilentlyContinue
        Unregister-ScheduledTask -TaskName $TaskName -Confirm:$false -ErrorAction Stop
        Write-Host "      ✓ Task '$TaskName' removed" -ForegroundColor Green
    } else {
        Write-Host "      ✓ Task not found (already removed)" -ForegroundColor Gray
    }
} catch {
    Write-Host "      ✗ Failed: $_" -ForegroundColor Red
    $allOk = $false
}

# ── Remove agent files ────────────────────────────────────────────────────────
Write-Host "[2/2] Removing agent files..." -ForegroundColor Yellow
try {
    if (Test-Path $AgentDir) {
        Remove-Item $AgentDir -Recurse -Force -ErrorAction Stop
        Write-Host "      ✓ Removed: $AgentDir" -ForegroundColor Green
    } else {
        Write-Host "      ✓ Directory not found (already removed)" -ForegroundColor Gray
    }
} catch {
    Write-Host "      ✗ Failed: $_" -ForegroundColor Red
    $allOk = $false
}

Write-Host ""
Write-Host "╔══════════════════════════════════════╗" -ForegroundColor Cyan
if ($allOk) {
    Write-Host "║         UNINSTALL COMPLETE           ║" -ForegroundColor Green
} else {
    Write-Host "║       UNINSTALL PARTIALLY FAILED     ║" -ForegroundColor Yellow
}
Write-Host "╚══════════════════════════════════════╝" -ForegroundColor Cyan
Write-Host ""