<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
header('Content-Type: application/json');
require_once __DIR__ . '/db.php';

$json = file_get_contents('php://input');
$data = json_decode($json, true);

if (!$data || empty($data['vm_id'])) {
    echo json_encode(["status" => "error", "msg" => "vm_id missing"]);
    exit;
}

$vmId        = (int)$data['vm_id'];
$group       = trim($data['group_name']   ?? '');
$rdp         = trim($data['rdp_nickname'] ?? '');
$isHeartbeat = isset($data['action']) && $data['action'] === 'heartbeat';
$bal         = (isset($data['balance']) && $data['balance'] !== null && $data['balance'] !== '')
    ? (float)preg_replace('/[^0-9.]/', '', (string)$data['balance'])
    : null;
$traf        = (float)preg_replace('/[^0-9.]/', '', (string)($data['traffic'] ?? '0'));
$stat        = trim($data['status'] ?? '');
$token       = trim($data['earnapp_token'] ?? '');
$ip          = trim($data['ip_address'] ?? $_SERVER['REMOTE_ADDR']);

$allowed = ['Running', 'Blocked', 'Paused', 'Connecting', 'Offline'];
if (!in_array($stat, $allowed, true)) $stat = null;
if ($stat === 'Connecting') $stat = 'Offline';

// VM exists check
$chkRes = $conn->query("SELECT id FROM vms WHERE id=" . $vmId . " LIMIT 1");
if (!$chkRes || $chkRes->num_rows === 0) {
    echo json_encode(["status" => "error", "msg" => "VM not registered: $vmId"]);
    exit;
}

// Token conflict
if (!$isHeartbeat && !empty($token)) {
    $tcRes = $conn->query("SELECT id FROM vms WHERE earnapp_token='" . $conn->real_escape_string($token) . "' AND id != " . $vmId . " LIMIT 1");
    if ($tcRes && $tcRes->num_rows > 0) {
        $oldRow = $tcRes->fetch_assoc();
        $oldId  = (int)$oldRow['id'];
        $conn->query("UPDATE vms SET earnapp_token=NULL, status='Offline' WHERE id=" . $oldId);
        $conn->query("INSERT INTO vm_commands (vm_id, command, status, created_at) VALUES (" . $oldId . ", 'stop_agent', 'pending', UTC_TIMESTAMP())");
    }
}

// Update vms
$setParts   = [];
$setParts[] = "current_ip='"   . $conn->real_escape_string($ip) . "'";
$setParts[] = "last_heartbeat=NOW()";

if (!$isHeartbeat) {
    $setParts[] = "traffic=" . $traf;
    if (!empty($token))    $setParts[] = "earnapp_token='" . $conn->real_escape_string($token) . "'";
    if ($stat !== null)    $setParts[] = "status='" . $conn->real_escape_string($stat) . "'";
    if ($bal  !== null)    $setParts[] = "balance=" . $bal;
}

$updateSql = "UPDATE vms SET " . implode(',', $setParts) . " WHERE id=" . $vmId;
$ok = $conn->query($updateSql);

if (!$ok) {
    echo json_encode(["status" => "error", "msg" => "UPDATE failed: " . $conn->error]);
    exit;
}

// earnapp_history
if (!$isHeartbeat && $stat !== null && in_array($stat, ['Running','Blocked','Paused'], true)) {
    date_default_timezone_set('Asia/Kolkata');
    $earningDate = date('Y-m-d');
    $balHist     = $bal !== null ? $bal : 0;
    $safeGroup   = $conn->real_escape_string($group);
    $safeRdp     = $conn->real_escape_string($rdp);
    $safeToken   = $conn->real_escape_string($token);
    $safeStat    = $conn->real_escape_string($stat);
    $safeIp      = $conn->real_escape_string($ip);

    $histSql = "INSERT INTO earnapp_history
        (vm_id, earning_date, group_name, rdp_nickname, balance, ip_address, earnapp_token, status)
        VALUES ($vmId, '$earningDate', '$safeGroup', '$safeRdp', $balHist, '$safeIp', '$safeToken', '$safeStat')
        ON DUPLICATE KEY UPDATE
            balance=VALUES(balance), status=VALUES(status),
            ip_address=VALUES(ip_address), recorded_at=CURRENT_TIMESTAMP";

    $histOk = $conn->query($histSql);
    if (!$histOk) {
        // Log but don't fail - history insert is non-critical
        error_log("earnapp_history insert failed: " . $conn->error);
    }
}

echo json_encode(["status" => "success"]);
$conn->close();