<?php
header('Content-Type: application/json');
require_once __DIR__ . '/db.php';

$db = mysqli_fetch_row(mysqli_query($conn,"SELECT DATABASE()"))[0];

$tables = [];
$q = mysqli_query($conn,"
SELECT table_name 
FROM information_schema.tables 
WHERE table_schema = '$db'
");
while ($r = mysqli_fetch_assoc($q)) {
    $tables[] = $r['table_name'];
}

if (in_array('agents', $tables)) {
    $sql = "SELECT * FROM agents";
} elseif (in_array('vm_commands', $tables)) {
    $sql = "
    SELECT 
        vm_id,
        status,
        created_at AS last_seen,
        ip
    FROM vm_commands
    GROUP BY vm_id
    ORDER BY created_at DESC
    ";
} elseif (in_array('vm_ip_reports', $tables)) {
    $sql = "SELECT * FROM vm_ip_reports ORDER BY updated_at DESC";
} else {
    echo json_encode([]);
    exit;
}

$res = mysqli_query($conn, $sql);

if (!$res) {
    http_response_code(500);
    echo json_encode(mysqli_error($conn));
    exit;
}

$data = [];
while ($row = mysqli_fetch_assoc($res)) {
    $data[] = $row;
}

echo json_encode($data);
