<?php
  $page = $_GET['page'] ?? 'dashboard';
?>

<aside class="sidebar open" id="sidebar">
  <div class="logo">
    <i class="fa-solid fa-shield-dog"></i>
    <span>BDMA</span>
  </div>

  <ul class="menu">
    <li class="<?= ($page === 'dashboard') ? 'active' : '' ?>">
      <a href="index.php?page=dashboard"><i class="fa-solid fa-grid"></i> Dashboard</a>
    </li>
    <li class="<?= ($page === 'reports') ? 'active' : '' ?>">
      <a href="index.php?page=reports"><i class="fa-solid fa-table"></i> Reports</a>
    </li>
    <li class="<?= ($page === 'analytics') ? 'active' : '' ?>">
      <a href="index.php?page=analytics"><i class="fa-solid fa-chart-line"></i> Analytics</a>
    </li>
    <li class="<?= ($page === 'earnings') ? 'active' : '' ?>">
      <a href="index.php?page=earnings"><i class="fa-solid fa-dollar-sign"></i> Earnings</a>
    </li>
    <li class="<?= ($page === 'ip-analysis') ? 'active' : '' ?>">
      <a href="index.php?page=ip-analysis"><i class="fa-solid fa-network-wired"></i> IP Analysis</a>
    </li>
    <li class="<?= ($page === 'commands') ? 'active' : '' ?>">
      <a href="index.php?page=commands"><i class="fa-solid fa-command"></i> All Commands</a>
    </li>
    <li>
      <a href="logout.php"><i class="fa-solid fa-right-from-bracket"></i> Logout</a>
    </li>
  </ul>
</aside>

<button id="sidebarToggle" class="sidebar-float-btn">
  <i class="fa-solid fa-angle-right"></i>
</button>

<style>
* {
  box-sizing: border-box;
}

html, body {
  margin: 0;
  padding: 0;
  width: 100%;
  height: 100%;
  overflow-x: hidden;
}

.sidebar {
  position: fixed;
  top: 0;
  bottom: 0;
  left: 0;
  width: 240px;
  background: #0b0b0b;
  color: #fff;
  transform: translateX(-240px);
  transition: transform 0.3s ease;
  z-index: 9999;
  overflow-y: auto;
  scrollbar-width: none;
  -ms-overflow-style: none;
}

.sidebar::-webkit-scrollbar {
  display: none;
}

.sidebar.open {
  transform: translateX(0);
}

.sidebar .logo {
  display: flex;
  align-items: center;
  gap: 10px;
  padding: 16px;
  font-size: 18px;
}

.menu {
  list-style: none;
  margin: 0;
  padding: 0;
}

.menu li a {
  display: flex;
  align-items: center;
  gap: 12px;
  padding: 12px 16px;
  color: #cfcfcf;
  text-decoration: none;
}

.menu li.active a,
.menu li a:hover {
  background: #161616;
  color: #fff;
}

.sidebar-float-btn {
  position: fixed;
  top: 50%;
  left: 0;
  transform: translateY(-50%);
  width: 28px;
  height: 64px;
  background: #111;
  color: #c77dff;
  border: 1px solid #333;
  border-left: none;
  border-radius: 0 10px 10px 0;
  cursor: pointer;
  z-index: 10000;
  transition: left 0.3s ease;
  display: flex;
  align-items: center;
  justify-content: center;
  padding: 0;
}

.sidebar.open ~ .sidebar-float-btn {
  left: 240px;
}

.sidebar-float-btn i {
  transition: transform 0.3s ease;
}

.sidebar.open ~ .sidebar-float-btn i {
  transform: rotate(180deg);
}

.main {
  margin-left: 0;
  width: 100%;
  min-height: 100vh;
  transition: margin-left 0.3s ease, width 0.3s ease;
}

.sidebar.open ~ .main {
  margin-left: 240px;
  width: calc(100% - 240px);
}
</style>

<script>
document.getElementById('sidebarToggle').onclick = function () {
  document.getElementById('sidebar').classList.toggle('open');
};
</script>