<?php
ob_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();

if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

$page = $_GET['page'] ?? 'dashboard';

$allowed = [
    'dashboard',
    'reports',
    'settings',
    'users',
    'analytics',
    'earnings',
    'ip-analysis',
    'commands',
    'proxies',
    'archive',
    'cold-tokens'
];

if (!in_array($page, $allowed, true)) {
    $page = 'dashboard';
}

$file = __DIR__ . '/pages/' . $page . '.php';

if (!is_file($file)) {
    $file = __DIR__ . '/pages/dashboard.php';
}
?>

<?php include __DIR__ . '/includes/head.php'; ?>
<body>

<?php include __DIR__ . '/includes/sidebar.php'; ?>

<div class="main">
    <?php include __DIR__ . '/includes/topbar.php'; ?>
    <?php include $file; ?>
</div>

<?php include __DIR__ . '/includes/footer.php'; ?>

</body>
</html>
