<?php
require_once 'db.php';

$threshold = 0.29;

if (isset($_GET['fetch']) && $_GET['fetch'] == '1') {
    set_time_limit(0);
    $vms_query = $conn->query("SELECT * FROM vms WHERE earnapp_token IS NOT NULL AND earnapp_token != ''");
    while ($vm = $vms_query->fetch_assoc()) {
        $token = trim($vm['earnapp_token']);
        $ch = curl_init("https://earnapp.com/api/v2/money");
        curl_setopt_array($ch, [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_TIMEOUT => 20,
            CURLOPT_HTTPHEADER => [
                "Authorization: Bearer " . $token,
                "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36"
            ],
        ]);
        $response = curl_exec($ch);
        $data = json_decode($response, true);
        curl_close($ch);

        if (isset($data['balance'])) {
            $new_balance = (float)$data['balance'];
            $new_traffic = (float)($data['total_earnings'] ?? 0);
            $conn->query("UPDATE vms SET balance = $new_balance, traffic = $new_traffic, last_updated = CURRENT_TIMESTAMP WHERE vm_id = " . (int)$vm['vm_id']);
            
            $vm_id_esc = $conn->real_escape_string((string)$vm['vm_id']);
            $rdp_esc = $conn->real_escape_string((string)$vm['rdp_nickname']);
            $group_esc = $conn->real_escape_string((string)$vm['group_name']);
            $ip_esc = $conn->real_escape_string((string)($vm['current_ip'] ?? '0.0.0.0'));
            $token_esc = $conn->real_escape_string($token);
            
            $conn->query("
                INSERT INTO earnapp_history
                (vm_id, group_name, rdp_nickname, balance, total, ip_address, earnapp_token, recorded_at)
                VALUES
                ('$vm_id_esc', '$group_esc', '$rdp_esc', '$new_balance', '$new_traffic', '$ip_esc', '$token_esc', UTC_TIMESTAMP())
            ");
        }
    }
}

$vms_query = $conn->query("
    SELECT v.*, 
    COALESCE((SELECT h.balance FROM earnapp_history h WHERE h.vm_id = v.vm_id AND DATE(h.recorded_at) = UTC_DATE() ORDER BY h.recorded_at ASC LIMIT 1), v.balance) as day_start_bal,
    COALESCE((SELECT h.balance FROM earnapp_history h WHERE h.vm_id = v.vm_id AND DATE(h.recorded_at) = SUBDATE(UTC_DATE(), 1) ORDER BY h.recorded_at DESC LIMIT 1), 0) as yest_end_bal,
    COALESCE((SELECT h.balance FROM earnapp_history h WHERE h.vm_id = v.vm_id AND DATE(h.recorded_at) = SUBDATE(UTC_DATE(), 1) ORDER BY h.recorded_at ASC LIMIT 1), 0) as yest_start_bal
    FROM vms v
");

$stats = ['total' => 0, 'ok' => 0, 'blocked' => 0, 'unchecked' => 0];
$nested_data = [];

while($row = $vms_query->fetch_assoc()) {
    $cur = (float)($row['balance'] ?? 0);
    $today_start = (float)($row['day_start_bal'] ?? 0);
    $yest_start = (float)($row['yest_start_bal'] ?? 0);
    $yest_end = (float)($row['yest_end_bal'] ?? 0);

    $t_earn = max(0, $cur - $today_start);
    $y_earn = max(0, $yest_end - $yest_start);
    $change = ($y_earn > 0) ? (($t_earn - $y_earn) / $y_earn) * 100 : 0;

    $isOnline = (!empty($row['last_heartbeat']) && strtotime($row['last_heartbeat']) >= strtotime('-5 minutes'));
    $st = strtolower($row['status'] ?? '');
    
    $vm_status = 'unchecked';
    if (in_array($st, ['blocked', 'anomaly'])) {
        $stats['blocked']++;
        $vm_status = 'blocked';
    } elseif ($isOnline) {
        $stats['ok']++;
        $vm_status = 'ok';
    } else {
        $stats['unchecked']++;
    }
    $stats['total']++;

    $g = $row['group_name'] ?: 'Default';
    $r = $row['rdp_nickname'] ?: 'Default RDP';

    if(!isset($nested_data[$g])) {
        $nested_data[$g] = ['rdps' => [], 'total_vms' => 0, 'ok' => 0, 'blocked' => 0, 'unchecked' => 0, 'earn' => 0, 'y_earn' => 0];
    }
    if(!isset($nested_data[$g]['rdps'][$r])) {
        $nested_data[$g]['rdps'][$r] = ['vms' => [], 'total_vms' => 0, 'ok' => 0, 'blocked' => 0, 'unchecked' => 0, 'earn' => 0, 'y_earn' => 0];
    }

    $vm_entry = [
        'unit_id' => $row['unit_id'] ?: '000',
        'ip' => $row['current_ip'] ?: '-',
        'status' => $vm_status,
        'earn' => $t_earn,
        'change' => $change
    ];

    $nested_data[$g]['rdps'][$r]['vms'][] = $vm_entry;
    $nested_data[$g]['rdps'][$r]['total_vms']++;
    $nested_data[$g]['rdps'][$r]['earn'] += $t_earn;
    $nested_data[$g]['rdps'][$r]['y_earn'] += $y_earn;
    
    $nested_data[$g]['total_vms']++;
    $nested_data[$g]['earn'] += $t_earn;
    $nested_data[$g]['y_earn'] += $y_earn;
    
    if($vm_status == 'ok') {
        $nested_data[$g]['rdps'][$r]['ok']++;
        $nested_data[$g]['ok']++;
    } elseif($vm_status == 'blocked') {
        $nested_data[$g]['rdps'][$r]['blocked']++;
        $nested_data[$g]['blocked']++;
    } else {
        $nested_data[$g]['rdps'][$r]['unchecked']++;
        $nested_data[$g]['unchecked']++;
    }
}
?>

<div class="container-fluid p-4">
    <div class="stat-strip">
        <div class="stat-box box-total"><i class="fas fa-desktop  "></i><div class="val"><?= $stats['total'] ?></div><div class="lbl">Total VMs</div></div>
        <div class="stat-box box-online"><i class="fas fa-check-circle text-green"></i><div class="val"><?= $stats['ok'] ?></div><div class="lbl">Online</div></div>
        <div class="stat-box box-pending"><i class="fas fa-clock  "></i><div class="val"><?= $stats['unchecked'] ?></div><div class="lbl">Pending</div></div>
        <div class="stat-box box-anomaly"><i class="fas fa-exclamation-triangle text-yellow"></i><div class="val"><?= $stats['blocked'] ?></div><div class="lbl">Anomalies</div></div>
    </div>

    <div class="analysis-bar">
        <div style="font-weight: bold; font-size: 1.2rem; margin-right: 20px;"><i class="fas fa-network-wired me-2"></i> IP Analysis</div>
        <div class="analysis-item"><i class="fas fa-desktop  "></i> <span><?= $stats['total'] ?></span> <span class="label-tag">TOTAL VMS</span></div>
        <div class="analysis-item"><i class="fas fa-check-circle text-green"></i> <span><?= $stats['ok'] ?></span> <span class="label-tag">OK</span></div>
        <div class="analysis-item"><i class="fas fa-ban text-red"></i> <span><?= $stats['blocked'] ?></span> <span class="label-tag">BLOCKED</span></div>
        <div class="analysis-item"><i class="fas fa-question-circle text-yellow"></i> <span><?= $stats['unchecked'] ?></span> <span class="label-tag">UNCHECKED</span></div>
        <div class="ms-auto"><a href="?page=ip-analysis&fetch=1" class="btn btn-sm btn-danger px-4 fw-bold"><i class="fas fa-search me-2"></i> CHECK ALL IPS</a></div>
    </div>

    <div class="mt-4">
        <?php foreach($nested_data as $groupName => $group): ?>
        <div class="accordion-group">
            <div class="accordion-header" data-bs-toggle="collapse" data-bs-target="#group-<?= md5((string)$groupName) ?>">
                <div class="group-info">
                    <i class="fas fa-folder-open text-purple"></i>
                    <span class="fw-bold"><?= strtoupper((string)$groupName) ?></span>
                    <span class="badge-purple"><?= (int)$group['total_vms'] ?> VMs</span>
                </div>
                <div class="d-flex align-items-center gap-3">
                    <div class="d-flex gap-2">
                        <div class="status-badge-pill text-green"><i class="fas fa-check small"></i> <?= (int)$group['ok'] ?></div>
                        <div class="status-badge-pill text-red"><i class="fas fa-ban small"></i> <?= (int)$group['blocked'] ?></div>
                        <div class="status-badge-pill "><i class="fas fa-question small"></i> <?= (int)$group['unchecked'] ?></div>
                    </div>
                    <?php $g_ch = ((float)($group['y_earn'] ?? 0) > 0) ? (((float)$group['earn'] - (float)$group['y_earn']) / (float)$group['y_earn']) * 100 : 0; ?>
                    <div class="d-flex align-items-center gap-2 ms-4">
                        <span class="text-green fw-bold">$<?= number_format((float)($group['earn'] ?? 0), 2) ?></span>
                        <span class="change-pill <?= $g_ch >= 0 ? 'bg-soft-green' : 'bg-soft-red' ?>"><?= ($g_ch >= 0 ? '+' : '') . number_format($g_ch, 1) ?>%</span>
                    </div>
                    <button class="header-btn ms-2"><i class="fas fa-search me-1"></i> Check</button>
                </div>
            </div>

            <div class="collapse show" id="group-<?= md5((string)$groupName) ?>">
                <?php foreach($group['rdps'] as $rdpName => $rdp): ?>
                <div class="rdp-container">
                    <div class="rdp-header" data-bs-toggle="collapse" data-bs-target="#rdp-<?= md5((string)$rdpName . (string)$groupName) ?>">
                        <div class="d-flex align-items-center gap-2">
                            <i class="fas fa-server text-info small"></i>
                            <span class="fw-bold text-info small"><?= strtoupper((string)$rdpName) ?></span>
                            <span class="badge bg-dark" style="font-size: 9px;"><?= (int)$rdp['total_vms'] ?> VMS</span>
                        </div>
                        <div class="d-flex align-items-center gap-4">
                            <div class="d-flex gap-1">
                                <div class="rdp-stat-box" style="background: rgba(0,230,118,0.1); color: var(--accent-green);"><?= (int)$rdp['ok'] ?></div>
                                <div class="rdp-stat-box" style="background: rgba(255,59,59,0.1); color: var(--accent-red);"><?= (int)$rdp['blocked'] ?></div>
                            </div>
                            <?php $r_ch = ((float)($rdp['y_earn'] ?? 0) > 0) ? (((float)$rdp['earn'] - (float)$rdp['y_earn']) / (float)$rdp['y_earn']) * 100 : 0; ?>
                            <div class="d-flex align-items-center gap-2">
                                <span class="text-green fw-bold small">$<?= number_format((float)($rdp['earn'] ?? 0), 2) ?></span>
                                <span class="change-pill <?= $r_ch >= 0 ? 'bg-soft-green' : 'bg-soft-red' ?>" style="font-size: 9px;"><?= ($r_ch >= 0 ? '+' : '') . number_format($r_ch, 1) ?>%</span>
                            </div>
                            <div class="header-btn" style="padding: 2px 8px;"><i class="fas fa-search"></i></div>
                        </div>
                    </div>
                    <div class="collapse show" id="rdp-<?= md5((string)$rdpName . (string)$groupName) ?>">
                        <?php foreach($rdp['vms'] as $vm): ?>
                        <div class="vm-row">
                            <div class="vm-id"><?= htmlspecialchars((string)($vm['unit_id'] ?? '')) ?></div>
                            <div class="vm-ip-status">
                                <div class=" "><i class="fas fa-wifi me-1"></i> <?= htmlspecialchars((string)($vm['ip'] ?? '')) ?></div>
                                <div class="status-pill status-<?= htmlspecialchars((string)($vm['status'] ?? 'unchecked')) ?>">
                                    <?= strtoupper(($vm['status'] ?? '') == 'ok' ? 'OK' : (($vm['status'] ?? '') == 'unchecked' ? 'OFFLINE' : (string)($vm['status'] ?? ''))) ?>
                                </div>
                            </div>
                            <div class="vm-earn">
                                <div>
                                    <span class="earn-val text-green">$<?= number_format((float)($vm['earn'] ?? 0), 2) ?></span>
                                    <span class="change-val <?= ($vm['change'] ?? 0) >= 0 ? 'text-green' : 'text-red' ?>">
                                        <?= (($vm['change'] ?? 0) >= 0 ? '▲' : '▼') . number_format(abs((float)($vm['change'] ?? 0)), 1) ?>%
                                    </span>
                                </div>
                                <i class="fas fa-search   small cursor-pointer"></i>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
        <?php endforeach; ?>
    </div>
</div>