<#
.SYNOPSIS
    SinnerWatchdog Uninstaller
    - Removes Scheduled Task
    - Removes Agent Files
#>

Write-Host "`n========================================" -ForegroundColor Cyan
Write-Host "  SinnerWatchdog Agent Uninstaller" -ForegroundColor Cyan
Write-Host "========================================`n" -ForegroundColor Cyan

$AgentDir = "$env:APPDATA\SinnerWatchdog"
$TaskName = "SinnerWatchdogAgent"

# 1. Stop and Remove Scheduled Task
Write-Host "[1/2] Removing scheduled task..." -ForegroundColor Yellow
try {
    $task = Get-ScheduledTask -TaskName $TaskName -ErrorAction SilentlyContinue
    if ($task) {
        Stop-ScheduledTask -TaskName $TaskName -ErrorAction SilentlyContinue
        Unregister-ScheduledTask -TaskName $TaskName -Confirm:$false -ErrorAction Stop
        Write-Host "      Scheduled task removed" -ForegroundColor Green
    } else {
        Write-Host "      Scheduled task not found (already removed)" -ForegroundColor Gray
    }
} catch {
    Write-Host "      Failed to remove scheduled task: $_" -ForegroundColor Red
}

# 2. Remove Agent Directory
Write-Host "`n[2/2] Removing agent files..." -ForegroundColor Yellow
try {
    if (Test-Path $AgentDir) {
        Remove-Item -Path $AgentDir -Recurse -Force -ErrorAction Stop
        Write-Host "      Agent directory removed: $AgentDir" -ForegroundColor Green
    } else {
        Write-Host "      Agent directory not found (already removed)" -ForegroundColor Gray
    }
} catch {
    Write-Host "      Failed to remove agent directory: $_" -ForegroundColor Red
}

Write-Host "`n========================================" -ForegroundColor Cyan
Write-Host "  UNINSTALL COMPLETE" -ForegroundColor Green
Write-Host "========================================`n" -ForegroundColor Cyan
Write-Host "You can now run a fresh install." -ForegroundColor Gray
