<?php
require_once 'db.php';

$selected_group = $_GET['group'] ?? '';
$selected_vm    = $_GET['vm'] ?? '';

$where_clauses = [];
if (!empty($selected_group)) {
    $where_clauses[] = "group_name = '" . $conn->real_escape_string($selected_group) . "'";
}
if (!empty($selected_vm)) {
    $where_clauses[] = "rdp_nickname = '" . $conn->real_escape_string($selected_vm) . "'";
}

$where_sql = "";
if (count($where_clauses) > 0) {
    $where_sql = " WHERE " . implode(" AND ", $where_clauses);
}

if (isset($_POST['delete_ids'])) {
    $ids_to_delete = $_POST['delete_ids'];
    if (!empty($ids_to_delete)) {
        $ids_string = implode(',', array_map('intval', $ids_to_delete));
        $conn->query("DELETE FROM earnapp_history WHERE id IN ($ids_string)");
        
        $redirect_url = $_SERVER['REQUEST_URI']; 
        echo "<script>window.location.href='$redirect_url';</script>";
        exit;
    }
}

$groups = [];
$vm_list = [];

$g_res = $conn->query("SELECT DISTINCT group_name FROM earnapp_history WHERE group_name IS NOT NULL AND group_name != ''");
while($r = $g_res->fetch_assoc()) $groups[] = $r['group_name'];

$v_res = $conn->query("SELECT DISTINCT rdp_nickname FROM earnapp_history WHERE rdp_nickname IS NOT NULL");
while($r = $v_res->fetch_assoc()) $vm_list[] = $r['rdp_nickname'];

$stats_sql = "SELECT COUNT(DISTINCT vm_id) as c FROM earnapp_history" . $where_sql;
$res = $conn->query($stats_sql);
$total_vms = $res ? $res->fetch_assoc()['c'] : 0;

$online_sql = "SELECT COUNT(DISTINCT vm_id) as c FROM earnapp_history 
               WHERE recorded_at >= UTC_TIMESTAMP() - INTERVAL 15 MINUTE";
if (!empty($selected_group)) $online_sql .= " AND group_name = '".$conn->real_escape_string($selected_group)."'";
if (!empty($selected_vm))    $online_sql .= " AND rdp_nickname = '".$conn->real_escape_string($selected_vm)."'";

$res = $conn->query($online_sql);
$online_vms = $res ? $res->fetch_assoc()['c'] : 0;

$bal_sql = "
SELECT 
    SUM(CASE WHEN DATE(recorded_at) = UTC_DATE() THEN balance ELSE 0 END) AS today_total,
    SUM(CASE WHEN DATE(recorded_at) = SUBDATE(UTC_DATE(), 1) THEN balance ELSE 0 END) AS yesterday_total,
    SUM(CASE WHEN YEAR(recorded_at) = YEAR(UTC_DATE()) AND MONTH(recorded_at) = MONTH(UTC_DATE()) THEN balance ELSE 0 END) AS month_total
FROM earnapp_history
" . $where_sql;

$res = $conn->query($bal_sql);
$row = $res->fetch_assoc();
$todayTotal = $row['today_total'] ?? 0;
$yesterdayTotal = $row['yesterday_total'] ?? 0;
$monthTotal = $row['month_total'] ?? 0;

$sql = "
SELECT 
    eh.id,
    eh.vm_id,
    eh.group_name,
    eh.rdp_nickname,
    eh.balance,
    eh.total,
    eh.ip_address,
    
    eh.earnapp_token,
    eh.recorded_at
FROM earnapp_history eh
LEFT JOIN vms v
    ON TRIM(LOWER(v.vm_id)) = TRIM(LOWER(eh.vm_id))
$where_sql
ORDER BY eh.rdp_nickname ASC, eh.recorded_at DESC
";



$result = $conn->query($sql);

$vms_data = [];
while ($row = $result->fetch_assoc()) {
    $vmKey = $row['rdp_nickname'];
    if (!isset($vms_data[$vmKey])) {
        $vms_data[$vmKey]['name'] = $row['rdp_nickname'];
        $vms_data[$vmKey]['ip'] = $row['ip_address'];
        $vms_data[$vmKey]['rows'] = [];
    }
    $vms_data[$vmKey]['rows'][] = $row;
}
?>

<style>
    .dashboard-container {
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        color: #e0e0e0;
    }
    .stat-card {
        background-color: #000000;
        border: 1px solid #333;
        border-radius: 12px;
        padding: 24px;
        text-align: center;
        height: 100%;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        box-shadow: 0 4px 6px rgba(0,0,0,0.3);
    }
    .stat-card h3 { font-size: 2rem; font-weight: 700; margin: 10px 0 5px 0; color: #fff; }
    .stat-card p { font-size: 0.75rem; text-transform: uppercase; letter-spacing: 1px; color: #888; margin: 0; }
    .icon-box { width: 50px; height: 50px; border-radius: 12px; display: flex; align-items: center; justify-content: center; font-size: 1.5rem; margin-bottom: 10px; }
    .border-red { border-bottom: 4px solid #d32f2f; }
    .border-green { border-bottom: 4px solid #388e3c; }
    .border-blue { border-bottom: 4px solid #1976d2; }
    .border-yellow { border-bottom: 4px solid #fbc02d; }
    .bg-icon-red { background-color: rgba(211, 47, 47, 0.2); color: #d32f2f; }
    .bg-icon-green { background-color: rgba(56, 142, 60, 0.2); color: #388e3c; }
    .bg-icon-blue { background-color: rgba(25, 118, 210, 0.2); color: #1976d2; }
    .bg-icon-yellow { background-color: rgba(251, 192, 45, 0.2); color: #fbc02d; }
    .form-select-dark { background-color: #000; color: #fff; border: 1px solid #333; border-radius: 6px; padding: 8px 12px; }
    .form-select-dark:focus { background-color: #111; color: #fff; border-color: #d32f2f; outline: none; }
    .btn-refresh { background-color: #d32f2f; color: white; border: none; padding: 8px 20px; font-weight: 600; text-decoration: none; display: inline-block; }
    .btn-refresh:hover { background-color: #b71c1c; color: white; }
    .accordion-item { background-color: #111; border: 1px solid #222; }
    .accordion-button { background-color: #161616; color: #eee; }
    .accordion-button:not(.collapsed) { background-color: #222; color: #fff; box-shadow: none; }
    .accordion-button::after { filter: invert(1); }
    .table-dark-custom { --bs-table-bg: #111; --bs-table-color: #ccc; border-color: #333; }
    .row-header { background-color: #1a1a1a; color: #fff; font-weight: bold; }
</style>

<div class="container-fluid px-4 py-4 dashboard-container">
    
    <div class="row align-items-center mb-5">
        <div class="col-md-5">
           <h3 class="fw-bold m-0">Earnings Dashboard Pro</h3> 
        </div>
        <div class="col-md-7">
            <form method="GET" action="" class="d-flex justify-content-end gap-2 flex-wrap">
                <?php 
                foreach ($_GET as $key => $value) {
                    if ($key == 'group' || $key == 'vm') continue;
                    echo '<input type="hidden" name="'.htmlspecialchars($key).'" value="'.htmlspecialchars($value).'">';
                }
                ?>
                
                <select name="group" class="form-select-dark" style="min-width: 150px;" onchange="this.form.submit()">
                    <option value="">All Groups</option>
                    <?php foreach($groups as $g): ?>
                        <option value="<?= htmlspecialchars($g) ?>" <?= $selected_group == $g ? 'selected' : '' ?>>
                            <?= htmlspecialchars($g) ?>
                        </option>
                    <?php endforeach; ?>
                </select>

                <select name="vm" class="form-select-dark" style="min-width: 150px;" onchange="this.form.submit()">
                    <option value="">All VMs</option>
                    <?php foreach($vm_list as $v): ?>
                        <option value="<?= htmlspecialchars($v) ?>" <?= $selected_vm == $v ? 'selected' : '' ?>>
                            <?= htmlspecialchars($v) ?>
                        </option>
                    <?php endforeach; ?>
                </select>

                <button type="submit" class="btn btn-refresh rounded">
                    <i class="fas fa-sync-alt me-2"></i> Refresh
                </button>
            </form>
        </div>
    </div>

    <div class="row mb-5 g-4">
        <div class="col-md-3 col-sm-6">
            <div class="stat-card border-red">
                <div class="icon-box bg-icon-red"><i class="fas fa-desktop"></i></div>
                <h3><?= $total_vms ?></h3>
                <p>Total VMs</p>
            </div>
        </div>

        <div class="col-md-3 col-sm-6">
            <div class="stat-card border-green">
                <div class="icon-box bg-icon-green"><i class="fas fa-check"></i></div>
                <h3><?= $online_vms ?></h3>
                <p>Online</p>
            </div>
        </div>

        <div class="col-md-3 col-sm-6">
            <div class="stat-card border-blue">
                <div class="icon-box bg-icon-blue"><i class="fas fa-clock"></i></div>
                <h3>$<?= number_format($yesterdayTotal, 2) ?></h3>
                <p>Yesterday</p>
            </div>
        </div>

        <div class="col-md-3 col-sm-6">
            <div class="stat-card border-yellow">
                <div class="icon-box bg-icon-yellow"><i class="fas fa-calendar-alt"></i></div>
                <h3>$<?= number_format($monthTotal, 2) ?></h3>
                <p>This Month</p>
            </div>
        </div>
    </div>

    <form id="bulkForm" method="POST">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h4 class="text-white">Earnings History</h4>
            <button type="button" class="btn btn-outline-danger btn-sm" onclick="confirmDelete()">
                <i class="fas fa-trash me-2"></i>Delete Selected
            </button>
        </div>

        <div class="accordion" id="vmAccordion">
            <?php 
            $count = 0;
            if(empty($vms_data)): 
            ?>
                <div class="p-5 text-center text-muted border border-secondary rounded bg-dark">No records found.</div>
            <?php 
            else:
                foreach ($vms_data as $vmName => $vmData):
                    $history = $vmData['rows'];
                    $ip = $vmData['ip'];
                    $count++;
                    $accordionId = "collapse" . $count;
            ?>
            <div class="accordion-item mb-3 rounded overflow-hidden">
                <h2 class="accordion-header">
                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#<?php echo $accordionId; ?>">
                        <div class="d-flex justify-content-between w-100 align-items-center pe-3">
                            <span class="d-flex align-items-center text-truncate">
                                <i class="fas fa-server me-3 text-secondary"></i> 
                                <span class="fw-bold me-2"><?php echo htmlspecialchars($vmName); ?></span>
                                <span class="text-muted small d-none d-md-inline"><?php echo htmlspecialchars($ip); ?></span>
                            </span>
                            <span class="badge bg-secondary"><?php echo count($history); ?></span>
                        </div>
                    </button>
                </h2>
                <div id="<?php echo $accordionId; ?>" class="accordion-collapse collapse" data-bs-parent="#vmAccordion">
                    <div class="accordion-body p-0">
                        <div class="table-responsive">
                            <table class="table table-sm table-dark-custom mb-0 align-middle">
                                <thead>
                                    <tr class="text-uppercase small text-muted">
                                        <th style="width: 40px;" class="ps-3">
                                            <input type="checkbox" class="form-check-input bg-dark border-secondary" onclick="selectVMRows(this, '<?php echo $accordionId; ?>')">
                                        </th>
                                        <th>Time</th>
                                        <th>VM</th>
                                        <th>RDP</th>
                                        <th>Group</th>
                                        <th>Balance</th>
                                        <th>Total</th>
                                        <th>IP Adress</th>
                                        <th>Status</th>
                                        <th>Token</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($history as $row): ?>
                                    <tr>
                                        <td class="ps-3">
                                            <input type="checkbox" name="delete_ids[]" value="<?php echo $row['id']; ?>" class="rowCheckbox form-check-input bg-dark border-secondary">
                                        </td>
                                        <td><?php echo date('M d, H:i', strtotime($row['recorded_at'])); ?></td>
                                        
                                        <td><?php echo htmlspecialchars($row['vm_id']); ?></td>
                                        <td><?php echo htmlspecialchars($row['group_name']); ?></td>
                                        <td><?php echo htmlspecialchars($row['rdp_nickname']); ?></td>
                                        
                                        <td class="text-success fw-bold">$<?php echo htmlspecialchars($row['balance']); ?></td>
                                        <td><?php echo htmlspecialchars($row['total']); ?></td>
                                        <td><?php echo htmlspecialchars($row['ip_address']); ?></td>
                                         <td>
                                            <?php
                                            $s = $conn->query("
                                                SELECT status 
                                                FROM vms 
                                                WHERE TRIM(LOWER(rdp_nickname)) = TRIM(LOWER('".$conn->real_escape_string($row['rdp_nickname'])."'))
                                                LIMIT 1
                                            ");
                                            $r = $s ? $s->fetch_assoc() : null;
                                            echo htmlspecialchars($r['status'] ?? 'closed');
                                            ?>
                                            </td>
                                        <td>
                                                  
                                            <div class="input-group input-group-sm" style="max-width: 150px;">
                                                <input type="text" class="form-control bg-dark text-muted border-secondary" id="tkn_<?php echo $row['id']; ?>" value="<?php echo htmlspecialchars($row['earnapp_token'] ?? ''); ?>" readonly>
                                                <button class="btn btn-outline-secondary" type="button" onclick="copyToken('tkn_<?php echo $row['id']; ?>')">
                                                    <i class="fas fa-copy"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <?php endforeach; endif; ?>
        </div>
    </form>
</div>

<script>
function selectVMRows(source, accordionId) {
    var container = document.getElementById(accordionId);
    var checkboxes = container.getElementsByClassName('rowCheckbox');
    for(var i=0; i<checkboxes.length; i++) {
        checkboxes[i].checked = source.checked;
    }
}

function copyToken(id) {
    var copyText = document.getElementById(id);
    copyText.select();
    navigator.clipboard.writeText(copyText.value);
}

function confirmDelete() {
    var checkedCount = document.querySelectorAll('.rowCheckbox:checked').length;
    if (checkedCount === 0) {
        alert("Select rows first");
        return;
    }
    if (confirm("Delete " + checkedCount + " records?")) {
        document.getElementById('bulkForm').submit();
    }
}
</script>