<?php 

require_once __DIR__ . '/db.php';

/*
ASSUMPTIONS
- cron runs every 5 minutes
- 1 heartbeat ≈ 1 minute
- earning only when earnapp_running = 1
*/

$RATE_PER_HOUR   = 0.02;
$RATE_PER_MINUTE = $RATE_PER_HOUR / 60;

/* ===============================
   STEP 1: MARK OFFLINE VMs
   =============================== */

$db->query("
    UPDATE vms
    SET status = 'offline'
    WHERE last_seen < (NOW() - INTERVAL 10 MINUTE)
");

/* ===============================
   STEP 2: CALCULATE TODAY EARNING
   =============================== */

$sql = "
SELECT vm_id, COUNT(*) AS minutes_online
FROM vm_heartbeats
WHERE DATE(created_at) = CURDATE()
  AND earnapp_running = 1
GROUP BY vm_id
";

$q = $db->query($sql);

while ($row = $q->fetch(PDO::FETCH_ASSOC)) {

    $vmId    = (int)$row['vm_id'];
    $minutes = (int)$row['minutes_online'];
    $earning = round($minutes * $RATE_PER_MINUTE, 4);

    $stmt = $db->prepare("
        INSERT INTO vm_earnings (vm_id, date, minutes_online, earning)
        VALUES (?, CURDATE(), ?, ?)
        ON DUPLICATE KEY UPDATE
            minutes_online = VALUES(minutes_online),
            earning = VALUES(earning)
    ");

    $stmt->execute([
        $vmId,
        $minutes,
        $earning
    ]);
}

/* ===============================
   STEP 3: CLEANUP OLD HEARTBEATS
   =============================== */
/* keep only 7 days */
$db->query("
    DELETE FROM vm_heartbeats
    WHERE created_at < (NOW() - INTERVAL 7 DAY)
");

echo "CRON OK\n";
