<?php
require_once __DIR__ . '/../db.php';

$raw = file_get_contents('php://input');
$json = json_decode($raw, true);
$data = is_array($json) ? $json : $_POST;

if (($data['action'] ?? '') === 'heartbeat') {

    $vm_id = (int)($data['vm_id'] ?? 0);
    if ($vm_id <= 0) exit;

    $earnapp_running   = (int)($data['earnapp_running'] ?? 0);
    $earnapp_autostart = (int)($data['earnapp_autostart'] ?? 0);
    $earnapp_paused    = (int)($data['earnapp_paused'] ?? 0);
    $current_ip        = $data['current_ip'] ?? '';

    $stmt = $pdo->prepare("
        UPDATE vms SET
            earnapp_running   = ?,
            earnapp_autostart = ?,
            earnapp_paused    = ?,
            current_ip        = ?,
            last_heartbeat    = NOW()
        WHERE id = ?
    ");
    $stmt->execute([
        $earnapp_running,
        $earnapp_autostart,
        $earnapp_paused,
        $current_ip,
        $vm_id
    ]);

    echo json_encode(['success' => true]);
    exit;
}

if (($data['action'] ?? '') === 'load_all') {

    $groups = [];

    $gq = $pdo->query("SELECT * FROM groups ORDER BY id");
    while ($g = $gq->fetch(PDO::FETCH_ASSOC)) {

        $g['rdps'] = [];

        $rq = $pdo->prepare("SELECT * FROM rdps WHERE group_id = ?");
        $rq->execute([$g['id']]);

        while ($r = $rq->fetch(PDO::FETCH_ASSOC)) {

            $r['vms'] = [];

            $vq = $pdo->prepare("
                SELECT
                    id,
                    name,
                    rdp_id,
                    CAST(earnapp_running AS UNSIGNED)   AS earnapp_running,
                    CAST(earnapp_autostart AS UNSIGNED) AS earnapp_autostart,
                    CAST(earnapp_paused AS UNSIGNED)    AS earnapp_paused,
                    current_ip,
                    last_heartbeat,
                    last_sync,
                    balance
                FROM vms
                WHERE rdp_id = ?
            ");
            $vq->execute([$r['id']]);

            while ($v = $vq->fetch(PDO::FETCH_ASSOC)) {
                $r['vms'][] = $v;
            }

            $g['rdps'][] = $r;
        }

        $groups[] = $g;
    }

    echo json_encode([
        'success' => true,
        'data' => [
            'data' => $groups,
            'server_time' => date('Y-m-d H:i:s')
        ]
    ]);
    exit;
}
