<?php
$tracking_result = null;
$error_message = '';

if (isset($_POST['tracking_number'])) {
    $tracking_number = trim($_POST['tracking_number']);
    
    if (!empty($tracking_number)) {
        // --- API Logic ---
        $api_key = 'YOUR_AFTERSHIP_API_KEY'; // Yahan apni API Key daalein
        $api_url = 'https://api.aftership.com/v4/trackings/dhl/' . $tracking_number;

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $api_url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'aftership-api-key: ' . $api_key,
            'Content-Type: application/json'
        ));

        $response = curl_exec($ch);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if ($http_code == 200) {
            $tracking_result = json_decode($response, true);
        } else {
            $error_message = "Could not find tracking information. Please check the number and try again.";
        }
    } else {
        $error_message = "Please enter a tracking number.";
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Track Your Order</title>
    <style>
        body { font-family: sans-serif; }
        .container { max-width: 800px; margin: 20px auto; padding: 20px; border: 1px solid #ccc; border-radius: 8px; }
        .tracking-form { margin-bottom: 20px; }
        .tracking-results { margin-top: 20px; }
        .checkpoint { border-left: 3px solid #007bff; padding-left: 15px; margin-bottom: 20px; }
        .checkpoint p { margin: 5px 0; }
    </style>
</head>
<body>
    <div class="container">
        <h1>Track Your Shipment</h1>
        <div class="tracking-form">
            <form method="post" action="tracking.php">
                <label for="tracking_number">Enter your Tracking Number:</label><br>
                <input type="text" id="tracking_number" name="tracking_number" size="40" required>
                <button type="submit">Track</button>
            </form>
        </div>

        <?php if ($error_message): ?>
            <p style="color: red;"><?php echo $error_message; ?></p>
        <?php endif; ?>

        <?php if ($tracking_result && isset($tracking_result['data']['tracking'])): ?>
            <?php $tracking_info = $tracking_result['data']['tracking']; ?>
            <div class="tracking-results">
                <h3>Tracking Details for #<?php echo htmlspecialchars($tracking_info['tracking_number']); ?></h3>
                <p><strong>Status:</strong> <?php echo htmlspecialchars($tracking_info['tag']); ?></p>
                <p><strong>Origin:</strong> <?php echo htmlspecialchars($tracking_info['origin_country_iso3']); ?></p>
                <p><strong>Destination:</strong> <?php echo htmlspecialchars($tracking_info['destination_country_iso3']); ?></p>
                
                <h4>Shipment History:</h4>
                <?php if (!empty($tracking_info['checkpoints'])): ?>
                    <?php foreach (array_reverse($tracking_info['checkpoints']) as $checkpoint): ?>
                        <div class="checkpoint">
                            <p><strong><?php echo date('F j, Y, g:i a', strtotime($checkpoint['checkpoint_time'])); ?></strong></p>
                            <p><?php echo htmlspecialchars($checkpoint['message']); ?></p>
                            <p><small><?php echo htmlspecialchars($checkpoint['location']); ?></small></p>
                        </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <p>No tracking history available yet.</p>
                <?php endif; ?>
            </div>
        <?php endif; ?>
    </div>
</body>
</html>