<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();
include 'session.php';
include 'db.php';
include 'send_email.php';

if (!isset($_SESSION['order_id'])) {
    $_SESSION['order_id'] = 'GRN' . rand(100000, 999999);
}
$order_id = $_SESSION['order_id'];

foreach (['step1', 'step2', 'step3'] as $step) {
    if (!isset($_SESSION[$step])) {
        header("Location: {$step}.php");
        exit;
    }
}
 

$step1 = $_SESSION['step1'] ?? [];
$step2 = $_SESSION['step2'] ?? [];
$step3 = $_SESSION['step3'] ?? [];
$step4 = $_SESSION['step4'] ?? [];

$plan = $step2['plan'] ?? 'Soft Copy';

$full_name       = $step1['full_name'] ?? '';
$dob             = $step1['dob'] ?? '';
$gender          = $step1['gender'] ?? '';
$email           = $step1['email'] ?? '';
$phone           = $step1['phone'] ?? '';
$nationality     = $step1['nationality'] ?? '';
$license_number  = $step1['license_number'] ?? '';
$birth_place     = $step1['birth_place'] ?? '';
$permanent_place = $step1['permanent_place'] ?? '';
$street          = $step1['street'] ?? ''; 
$state           = $step1['state'] ?? ''; 
$city            = $step1['city'] ?? ''; 

$perm_street = $street;
$perm_state  = $state;
$perm_city   = $city;


$type            = $step2['type'] ?? '';
$license_country = $step2['license_country'] ?? '';
$drive_country   = $step2['drive_country'] ?? '';
$license_class_arr = $step2['license_class'] ?? [];
$license_class_str = !empty($license_class_arr) ? implode(', ', $license_class_arr) : '';
$addons_arr      = $step2['addons'] ?? [];
$addons_str      = !empty($addons_arr) ? implode(',', $addons_arr) : '';
$promo           = $step2['promo'] ?? '';
$product         = $step2['productbooklet'] ?? '';
$validity        = $step2['validity'] ?? '1 year';

$passport_photo  = $step3['passport_photo'] ?? '';
$license_front   = $step3['license_front'] ?? '';
$license_back    = $step3['license_back'] ?? '';


if ($plan === 'Hard Copy') {
    $ship_fname   = $step4['first_name'] ?? '';
    $ship_lname   = $step4['last_name'] ?? '';
    $ship_house   = $step4['ship_house'] ?? '';
    $ship_street  = $step4['ship_street'] ?? '';
    $ship_city    = $step4['city'] ?? '';
    $ship_state   = $step4['state'] ?? '';
    $ship_zip     = $step4['zip'] ?? '';
    $ship_country = $step4['country_code'] ?? '';
    $shippingPrice = floatval($_SESSION['shipping_rate'] ?? 0);
} else {
    $ship_fname = $ship_lname = $ship_house = $ship_street = $ship_city = $ship_state = $ship_zip = $ship_country = '';
    $shippingPrice = 0;
}

$productPrice = floatval($_SESSION['step2']['product_price'] ?? $_SESSION['step2']['total'] ?? 0);

// Get other price components from the session
$upgradePrice = floatval($_SESSION['upgrade_amount'] ?? 0);
$shippingPrice = ($plan === 'Hard Copy') ? floatval($_SESSION['shipping_rate'] ?? 0) : 0;

// The final total is always the sum of its parts.
$total = $productPrice + $upgradePrice + $shippingPrice;


if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $admin_email = 'ranu.gupta581@gmail.com';
    $logo_url = 'https://eitca.instamantra.co.in/wp-content/uploads/2025/03/logo.png';

    ob_start();
    ?>
    <!DOCTYPE html>
    <html>
    <head>
        <meta charset="UTF-8">
        <title>Application Details</title>
        <style>
            body { font-family: Arial, sans-serif; margin: 0; padding: 0; background-color: #f4f4f4; }
            .email-container { max-width: 600px; margin: 20px auto; background-color: #ffffff; border: 1px solid #dddddd; border-radius: 8px; overflow: hidden; }
            .email-header { background-color: #fff; padding: 20px; text-align: center; }
            .email-header img { max-width: 150px; }
            .email-body { padding: 20px 30px; color: #333333; line-height: 1.6; }
            .email-body h2 { color: #004687; margin-top: 0; }
            .email-body h3 { border-bottom: 2px solid #eeeeee; padding-bottom: 10px; margin-top: 25px; color: #333333; }
            .detail-item { margin-bottom: 10px; }
            .detail-item strong { color: #555555; min-width: 150px; display: inline-block; }
            .email-footer { background-color: #f4f4f4; padding: 20px; text-align: center; font-size: 12px; color: #777777; }
        </style>
    </head>
    <body>
        <div class="email-container">
            <div class="email-header">
                <img src="<?= $logo_url ?>" alt="Company Logo">
            </div>
            <div class="email-body">
                <div id="email-greeting"></div>
                <h2>Application Summary</h2>

                <h3>Applicant's Details</h3>
                <div class="detail-item"><strong>Full Name:</strong> <?= htmlspecialchars($full_name) ?></div>
                <div class="detail-item"><strong>Date of Birth:</strong> <?= htmlspecialchars($dob) ?></div>
                <div class="detail-item"><strong>Email:</strong> <?= htmlspecialchars($email) ?></div>
                <div class="detail-item"><strong>Phone:</strong> <?= htmlspecialchars($phone) ?></div>
                <div class="detail-item"><strong>Address:</strong> <?= htmlspecialchars($street . ', ' . $city . ', ' . $state) ?></div>

                <h3>Plan Details</h3>
                <div class="detail-item"><strong>Plan:</strong> <?= htmlspecialchars($plan) ?></div>
                <div class="detail-item"><strong>Type:</strong> <?= htmlspecialchars($type) ?></div>
                <div class="detail-item"><strong>License Classes:</strong> <?= htmlspecialchars($license_class_str) ?></div>
                <div class="detail-item"><strong>Product:</strong> <?= htmlspecialchars($product) ?></div>
                <div class="detail-item"><strong>Validity:</strong> <?= htmlspecialchars($validity) ?></div>

                <?php if ($plan === 'Hard Copy'): ?>
                <h3>Shipping Address</h3>
                <div class="detail-item"><strong>Recipient Name:</strong> <?= htmlspecialchars($ship_fname . ' ' . $ship_lname) ?></div>
                <div class="detail-item"><strong>Address:</strong> <?= htmlspecialchars($ship_house . ', ' . $ship_street . ', ' . $ship_city . ', ' . $ship_state . ' ' . $ship_zip) ?></div>
                <div class="detail-item"><strong>Country:</strong> <?= htmlspecialchars($ship_country) ?></div>
                <?php endif; ?>

                <h3>Order Summary</h3>
                <div class="detail-item"><strong>Product Price:</strong> £<?= number_format($productPrice, 2) ?></div>
                <?php if ($plan === 'Hard Copy'): ?>
                <div class="detail-item"><strong>Shipping Price:</strong> £<?= number_format($shippingPrice, 2) ?></div>
                <?php endif; ?>
                <div class="detail-item"><strong>Total Amount:</strong> £<?= number_format($total, 2) ?></div>
                <div class="detail-item"><strong>Order ID:</strong> <?= htmlspecialchars($order_id) ?></div>
            </div>
            <div class="email-footer">
                <p>&copy; <?= date('Y') ?> Your Company Name. All rights reserved.</p>
                <p>This is an automated notification. Please do not reply to this email.</p>
            </div>
        </div>
    </body>
    </html>
    <?php
    $email_template = ob_get_clean();

    $admin_subject = "New Application Submitted - Order ID: " . $order_id;
    $admin_greeting = '<h2>New Application Received</h2><p>The following application has been submitted through the website:</p>';
    $admin_body = str_replace('<div id="email-greeting"></div>', $admin_greeting, $email_template);
    send_application_email($admin_email, 'Admin', $admin_subject, $admin_body);

    $applicant_email = $email;
    if (!empty($applicant_email) && filter_var($applicant_email, FILTER_VALIDATE_EMAIL)) {
        $applicant_subject = "Your Application Has Been Received - Order ID: " . $order_id;
        $applicant_greeting = '<h2>Thank You For Your Application!</h2><p>Dear ' . htmlspecialchars($full_name) . ',</p><p>We have successfully received your application. Here is a summary of your details. Please proceed to the payment page to complete your order.</p>';
        $applicant_body = str_replace('<div id="email-greeting"></div>', $applicant_greeting, $email_template);
        send_application_email($applicant_email, $full_name, $applicant_subject, $applicant_body);
    }

    $copy_type = ($plan === 'Hard Copy') ? 'Physical' : 'Digital';
    $shipping_price = ($plan === 'Hard Copy') ? $shippingPrice : 0;
    
    $stmt = $conn->prepare("
        INSERT INTO applications (
            order_id, full_name, dob, gender, email, phone, nationality,
            perm_state, perm_street, perm_city,
            license_number, plan, copy_type, type, license_country, drive_country,
            license_class, addons, promo,
            passport_photo, license_front, license_back,
            ship_fname, ship_lname, ship_house,
            street, state, zip, city, country,
            product, validity, shipping_price, total_price
        ) VALUES (
            ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?
        )
    ");

    if (!$stmt) {
        die("Prepare failed: " . $conn->error);
    }

    $stmt->bind_param(
        "ssssssssssssssssssssssssssssssssdd",
        $order_id, $full_name, $dob, $gender, $email, $phone, $nationality,
        $perm_state, $perm_street, $perm_city,
        $license_number, $plan, $copy_type, $type, $license_country, $drive_country,
        $license_class_str, $addons_str, $promo,
        $passport_photo, $license_front, $license_back,
        $ship_fname, $ship_lname, $ship_house,
        $ship_street, $ship_state, $ship_zip, $ship_city, $ship_country,
        $product, $validity, $shipping_price, $total
    );


    if ($stmt->execute()) {
        header("Location: thankyou.php");
        exit;
    } else {
        echo "Error: " . $stmt->error;
    }
}
?>
<!DOCTYPE html>
<html>
<head>
  <title>Step 5 - Review Details</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">

  <?php include('link.php'); ?>

  <style>
    .review-container {
        padding: 1rem 0;
    }
    .section {
        margin-bottom: 2rem;
        padding: 1.5rem;
        background-color: #ffffff;
        border: 1px solid #e9e9e9;
        border-radius: 8px;
        box-shadow: 0 2px 8px rgba(0,0,0,0.05);
    }
    .section h4 {
        margin-top: 0;
        color: #333;
        border-bottom: 1px solid #eee;
        padding-bottom: 0.75rem;
        margin-bottom: 1.5rem;
        font-size: 1.25rem;
        font-weight: 600;
    }
    .detail-row {
        display: flex;
        justify-content: flex-start;
        align-items: flex-start;
        padding: 0.6rem 0;
        font-size: 1rem;
    }
    .detail-label {
        flex: 0 0 250px;
        color: #555;
        padding-right: 1rem;
    }
    .detail-value {
        flex: 1;
        font-weight: 600;
        color: #222;
        word-break: break-word;
    }
    .uploaded-images-grid {
        display: flex;
        flex-wrap: wrap;
        gap: 1.5rem;
    }
    .image-item {
        text-align: center;
    }
    .image-item img {
        display: block;
        max-width: 120px;
        height: auto;
        border: 1px solid #ccc;
        border-radius: 4px;
        margin-bottom: 0.5rem;
    }
    .image-item .image-label {
        font-weight: 600;
        color: #333;
    }
    .summary-total {
        font-size: 1.2rem;
        font-weight: bold;
        color: #000;
        border-top: 2px solid #333;
        margin-top: 1rem;
        padding-top: 1rem;
    }
    .suggestion-box {
        margin-top: 30px;
        padding: 20px;
        background-color: #e0f7fa;
        border-radius: 8px;
        border-left: 5px solid #00bcd4;
        text-align: center;
    }
    .suggestion-box img { margin-bottom: 15px; }
    .suggestion-box p { font-size: 16px; color: #333; margin-bottom: 20px; }
    .suggestion-box a {
        display: inline-block;
        padding: 12px 25px;
        background-color: #007BFF;
        color: white;
        text-decoration: none;
        border-radius: 5px;
        font-weight: bold;
        transition: background-color 0.3s ease;
    }
    .suggestion-box a:hover { background-color: #0056b3; }

    .stats-card.marg {
        margin-top: 20px;
        padding: 15px;
        font-size: 12px !important;
    }
    .stats-card.marg .uploaded {
        position: relative;
        text-align: left;
    }
  </style>
</head>

<body>
  <?php include('header.php'); ?>

  <section class="step-section steplicence">
    <div class="step-header">
      <h1>Apply for International Driving License</h1>
      <p>Most accepted at the global level & trusted by travellers all around the world</p>
    </div>

    <div class="step-progress">
      <div class="step"><span class="number">01</span><span class="label">Applicant’s Details</span></div>
      <div class="step"><span class="number">02</span><span class="label">Choose Plan</span></div>
      <div class="step"><span class="number">03</span><span class="label">Add Document</span></div>
      <div class="step active"><span class="number">04</span><span class="label">Review</span></div>
      <div class="step"><span class="number">05</span><span class="label">Payment</span></div>
    </div>
  </section>

  <div class="licenceform">
    <div class="container">
      <div class="main-form-container">
        <div class="form-container review-container">

          <h2>Review Details</h2>
           
          <div class="section">
            <h4>Applicant’s Details</h4>
            <div class="detail-row"><span class="detail-label">Full Name:</span> <span class="detail-value"><?= htmlspecialchars($full_name) ?></span></div>
            <div class="detail-row"><span class="detail-label">Date of Birth:</span> <span class="detail-value"><?= htmlspecialchars($dob) ?></span></div>
            <div class="detail-row"><span class="detail-label">Gender:</span> <span class="detail-value"><?= htmlspecialchars($gender) ?></span></div>
            <div class="detail-row"><span class="detail-label">Email:</span> <span class="detail-value"><?= htmlspecialchars($email) ?></span></div>
            <div class="detail-row"><span class="detail-label">Phone:</span> <span class="detail-value"><?= htmlspecialchars($phone) ?></span></div>
            <div class="detail-row"><span class="detail-label">Nationality:</span> <span class="detail-value"><?= htmlspecialchars($nationality) ?></span></div>
            <div class="detail-row"><span class="detail-label">Country of License:</span> <span class="detail-value"><?= htmlspecialchars($license_country) ?></span></div>
            <div class="detail-row"><span class="detail-label">Permanent Place of Residence:</span> <span class="detail-value"><?= htmlspecialchars($birth_place) ?></span></div>
            <div class="detail-row"><span class="detail-label">Street:</span> <span class="detail-value"><?= htmlspecialchars($street) ?></span></div>
            <div class="detail-row"><span class="detail-label">State:</span> <span class="detail-value"><?= htmlspecialchars($state) ?></span></div>
            <div class="detail-row"><span class="detail-label">City:</span> <span class="detail-value"><?= htmlspecialchars($city) ?></span></div>
          </div>

          <div class="section">
            <h4>Choose Plan</h4>
            <div class="detail-row"><span class="detail-label">Plan:</span> <span class="detail-value"><?= htmlspecialchars($plan) ?></span></div>
            <div class="detail-row"><span class="detail-label">Type:</span> <span class="detail-value"><?= htmlspecialchars($type) ?></span></div>
            <div class="detail-row"><span class="detail-label">Intended Country to Drive:</span> <span class="detail-value"><?= htmlspecialchars($drive_country) ?></span></div>
            <div class="detail-row"><span class="detail-label">License Classes:</span> <span class="detail-value"><?= htmlspecialchars($license_class_str) ?></span></div>
            <div class="detail-row"><span class="detail-label">Product:</span> <span class="detail-value" id="product-name-display"><?= htmlspecialchars($product) ?></span></div>
            <div class="detail-row"><span class="detail-label">Validity:</span> <span class="detail-value"><?= htmlspecialchars($validity) ?></span></div>
            <div class="detail-row"><span class="detail-label">Promo Code:</span> <span class="detail-value"><?= htmlspecialchars($promo ?: 'N/A') ?></span></div>
          </div>

          <div class="section">
            <h4>Uploaded Documents</h4>
            <div class="uploaded-images-grid">
              <div class="image-item">
                <span class="image-label">Passport Photo:</span>
                <?php if (!empty($passport_photo) && file_exists('uploads/' . $passport_photo)): ?>
                  <img src="uploads/<?= htmlspecialchars($passport_photo) ?>" alt="Passport Photo">
                <?php else: ?>
                  <span class="detail-value">N/A</span>
                <?php endif; ?>
              </div>
              <div class="image-item">
                <span class="image-label">License Front:</span>
                <?php if (!empty($license_front) && file_exists('uploads/' . $license_front)): ?>
                  <img src="uploads/<?= htmlspecialchars($license_front) ?>" alt="License Front">
                <?php else: ?>
                  <span class="detail-value">N/A</span>
                <?php endif; ?>
              </div>
              <div class="image-item">
                <span class="image-label">License Back:</span>
                <?php if (!empty($license_back) && file_exists('uploads/' . $license_back)): ?>
                  <img src="uploads/<?= htmlspecialchars($license_back) ?>" alt="License Back">
                <?php else: ?>
                  <span class="detail-value">N/A</span>
                <?php endif; ?>
              </div>
            </div>
          </div>
          
          <?php if ($plan === 'Hard Copy'): ?>
          <div class="section"> 
              <h4>Shipping Address</h4>
              <div class="detail-row"><span class="detail-label">Recipient Name:</span> <span class="detail-value"><?= htmlspecialchars($ship_fname . ' ' . $ship_lname) ?></span></div>
              <div class="detail-row"><span class="detail-label">House/Flat/Block No.:</span> <span class="detail-value"><?= htmlspecialchars($ship_house) ?></span></div>
              <div class="detail-row"><span class="detail-label">Street/Area:</span> <span class="detail-value"><?= htmlspecialchars($ship_street) ?></span></div>
              <div class="detail-row"><span class="detail-label">City:</span> <span class="detail-value"><?= htmlspecialchars($ship_city) ?></span></div>
              <div class="detail-row"><span class="detail-label">State/Region/Province:</span> <span class="detail-value"><?= htmlspecialchars($ship_state) ?></span></div>
              <div class="detail-row"><span class="detail-label">ZIP/Postal Code:</span> <span class="detail-value"><?= htmlspecialchars($ship_zip) ?></span></div>
              <div class="detail-row"><span class="detail-label">Country:</span> <span class="detail-value"><?= htmlspecialchars($ship_country) ?></span></div>
          </div>
          <?php endif; ?>
          
        <div class="section">
    <h4>Order Summary</h4>
    <div id="price-breakdown">
        <div class="detail-row">
            <span class="detail-label">Product Price:</span>
            <span class="detail-value">£<?= number_format($productPrice, 2) ?></span>
        </div>

        <?php if (isset($_SESSION['upgrade_amount'])): // Show upgrade price if already applied ?>
        <div class="detail-row">
            <span class="detail-label">Upgrade Price</span>
            <span class="detail-value">£<?= number_format($_SESSION['upgrade_amount'], 2) ?></span>
        </div>
        <?php endif; ?>

        <?php if ($plan === 'Hard Copy'): ?>
            <div class="detail-row">
                <span class="detail-label">Shipping Price:</span>
                <span class="detail-value">£<?= number_format($shippingPrice, 2) ?></span>
            </div>
        <?php endif; ?>
    </div>
    <div class="detail-row summary-total">
        <span class="detail-label">Total Amount:</span>
        <span class="detail-value" id="total-amount-display">£<?= number_format($total, 2) ?></span>
    </div>
</div>

          <form method="post" action="">
            <div class="back-continue-button-wrap">
              <button type="button" class="first-btn-cicle" onclick="window.history.back()">Back</button>
              
       
              
              <button type="submit" class="btn secondary-btn-circle">Confirm & Proceed to Payment</button>
            </div>
          </form>

        </div>

        <div class="global-container">
          <?php include('stats-card.php'); ?>

          <?php if (($step2['productbooklet'] ?? '') === 'Booklet' && !isset($_SESSION['upgrade_amount'])) : // Hide if already upgraded ?>
            <div class="suggestion-box" id="suggestion-box">
                <img src="assets/slide.png" alt="Upgrade offer" width="70%">
                <p>Want more value? Switch to our premium <strong>Booklet + Card</strong> combo for a complete experience!</p>
                <a href="#" id="upgrade-button" class="btn">Upgrade Your Product</a>
            </div>
        <?php endif; ?>

          <div class="stats-card marg uploaded-images-wrap name_flex">
            <h4>Uploaded Documents</h4>
            <div class="uploaded">
                
            <div class="user_data_flex">
              <div class="username"><?= htmlspecialchars($step1['full_name'] ?? '') ?></div>
              <div class="username2"><?= htmlspecialchars($step1['nationality'] ?? '') ?></div>
              <div class="username3"><?= htmlspecialchars($step1['dob'] ?? '') ?></div>
              </div>
              
              <div class="username4">
              <?php if (!empty($passport_photo) && file_exists('uploads/' . $passport_photo)): ?>
                <img src="uploads/<?= htmlspecialchars($passport_photo) ?>" alt="Passport Photo Preview">
              <?php endif; ?>
               </div>
              <img src="certificate.jpg" alt="Sample Certificate" width="100%">
             
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <?php include('footer.php'); ?>
  <?php include('footerscript.php'); ?>
  
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script> <!-- Make sure jQuery is loaded -->

<script>
$(document).ready(function() {
    $('#upgrade-button').on('click', function(e) {
        e.preventDefault(); // Prevent the link from navigating

        var button = $(this);
        button.text('Upgrading...').prop('disabled', true); // Give user feedback

        $.ajax({
            url: 'ajax_upgrade.php',
            type: 'POST',
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    // 1. Update Product Name on the page
                    $('#product-name-display').text(response.newProductName);

                    // 2. Create the new "Upgrade Price" row
                    var upgradeRowHTML = `
                        <div class="detail-row" style="display:none;">
                            <span class="detail-label">Upgrade Price</span>
                            <span class="detail-value">£${response.upgradePrice.toFixed(2)}</span>
                        </div>`;
                    
                    // Add the new row to the price breakdown and fade it in
                    $(upgradeRowHTML).appendTo('#price-breakdown').fadeIn();

                    // 3. Update the Total Amount
                    $('#total-amount-display').text('£' + response.newTotalPrice.toFixed(2));

                    // 4. Hide the suggestion box with a nice animation
                    $('#suggestion-box').slideUp();
                } else {
                    alert('Error: ' + response.message);
                    button.text('Upgrade Your Product').prop('disabled', false);
                }
            },
            error: function() {
                alert('A server error occurred. Please try again.');
                button.text('Upgrade Your Product').prop('disabled', false);
            }
        });
    });
});
</script>
</body>
</html>