<?php
session_start();
include('db.php');
mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);

// --- Handle AJAX promo code validation ---
if (
    isset($_SERVER['HTTP_X_REQUESTED_WITH']) &&
    strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) === 'xmlhttprequest' &&
    isset($_POST['promo_code'])
) {
    $promo_code_to_validate = trim($_POST['promo_code']);
    $response = [
        'valid' => false,
        'discount_value' => 0,
        'discount_type' => '',
        'promo_id' => null,
        'error' => 'Invalid or expired promo code.'
    ];

    if (!empty($promo_code_to_validate)) {
        $stmt = $conn->prepare("
            SELECT id, promo, discount_type, discount_value 
            FROM addon_promo 
            WHERE promo=? AND (expiry_date IS NULL OR expiry_date >= CURDATE()) 
            LIMIT 1
        ");
        $stmt->bind_param("s", $promo_code_to_validate);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($row = $result->fetch_assoc()) {
            $response['valid'] = true;
            $response['discount_value'] = (float)$row['discount_value'];
            $response['discount_type'] = $row['discount_type'];
            $response['promo_id'] = $row['id'];
            $response['error'] = '';
        }
    }

    header('Content-Type: application/json');
    echo json_encode($response);
    exit;
}

// --- Handle Addons ---
if (isset($_POST['addons']) && is_array($_POST['addons'])) {
    $selected_addons_raw = $_POST['addons'];
    $addons_to_save = [];

    if (!empty($selected_addons_raw)) {
        $addon_names_for_query = [];
        $processed_addons_for_session = [];

        foreach ($selected_addons_raw as $addon_data_string) {
            $parts = explode('|', $addon_data_string);
            if (count($parts) === 2) {
                $addon_name = $parts[0];
                $addon_image = $parts[1];
                $addon_names_for_query[] = $addon_name;
                $processed_addons_for_session[] = ['name' => $addon_name, 'image' => $addon_image];
            }
        }

        if (!empty($addon_names_for_query)) {
            $placeholders = implode(',', array_fill(0, count($addon_names_for_query), '?'));
            $stmt = $conn->prepare("SELECT name, price FROM addon_products WHERE name IN ($placeholders)");
            $types = str_repeat('s', count($addon_names_for_query));
            $stmt->bind_param($types, ...$addon_names_for_query);
            $stmt->execute();
            $result = $stmt->get_result();

            $addon_prices = [];
            while ($row = $result->fetch_assoc()) {
                $addon_prices[$row['name']] = (float)$row['price'];
            }

            foreach ($processed_addons_for_session as $addon_data) {
                $addon_name = $addon_data['name'];
                $addon_image = $addon_data['image'];
                $addon_price = $addon_prices[$addon_name] ?? 0.0;

                $addons_to_save[] = [
                    'name' => $addon_name,
                    'image' => $addon_image,
                    'price' => $addon_price
                ];
            }
        }
    }

    $_SESSION['step2']['addons'] = $addons_to_save;
} else {
    unset($_SESSION['step2']['addons']);
}

// --- Handle Step 2 form submission and GRN generation ---
if (isset($_POST['step2_submit'])) {
    $_SESSION['step2'] = $_POST;

    $copy_type_selected = $_POST['plan'] ?? '';
    $prefix = '';
    if ($copy_type_selected === 'Soft Copy') {
        $prefix = 'GRN200-569-';
        $_SESSION['copy_type'] = 'soft';
    } elseif ($copy_type_selected === 'Hard Copy') {
        $prefix = 'GRN202-569-';
        $_SESSION['copy_type'] = 'hard';
    }

    if (!empty($prefix)) {
        if (!isset($_SESSION['generated_order_ids'])) {
            $_SESSION['generated_order_ids'] = [];
        }

        $next_sequence = count($_SESSION['generated_order_ids']) + 1;
        $sequence_str = str_pad($next_sequence, 4, '0', STR_PAD_LEFT);
        $order_id = $prefix . $sequence_str;

        $_SESSION['order_id'] = $order_id;
        $_SESSION['generated_order_ids'][] = $order_id;

        // Also store in Step 2 array for printing/debugging
        $_SESSION['step2']['order_id'] = $order_id;
    }

    $_SESSION['totalAmount'] = $_POST['total'] ?? '0.00';

    header("Location: step3.php");
    exit;
}

// --- Fetch latest form control prices ---
$sql = "SELECT * FROM form_controll ORDER BY id DESC LIMIT 1";
$result = $conn->query($sql);
$prices = $result->fetch_assoc();
?>
