<?php
include('step2_logic.php');
date_default_timezone_set('Europe/London');
$ukHour = (int)date('G');
$ukDay = (int)date('w');
$ukDateTime = date('Y-m-d H:i:s');

// Fetch form_controll data. This is crucial for getting image paths.
$formControll = $conn->query("SELECT * FROM form_controll ORDER BY id DESC LIMIT 1")->fetch_assoc();

// Ensure $prices array is initialized if step2_logic.php doesn't fully do it
if (!isset($prices)) {
    $prices = [];
}

// Populate $prices with image paths from formControll
// These will be used for displaying images in the form
$prices['soft_copy_file'] = $formControll['soft_copy_file'] ?? '';
$prices['hard_copy_file'] = $formControll['hard_copy_file'] ?? '';

// Booklet images based on your selected columns
$prices['booklet_front_image'] = $formControll['booklet_front_image'] ?? '';
$prices['booklet_card_booklet_front_image'] = $formControll['booklet_card_booklet_front_image'] ?? '';


$prices['weekend_type_price'] = $formControll['weekend_type_price'] ?? $prices['urgent_type_price'];
$prices['base_urgent_type_price'] = $prices['urgent_type_price'];

// Driving license classes (unchanged)
$driving_license_classes_data = [];
if (!empty($formControll['driving_license_classes'])) {
    $decoded_classes = json_decode($formControll['driving_license_classes'], true);
    if (is_array($decoded_classes)) {
        $driving_license_classes_data = $decoded_classes;
    }
}

// Countries data (unchanged)
$countries_data = [];
$sql = "SELECT country_code, country_name, idp_convention FROM countries ORDER BY country_name ASC";
$result = $conn->query($sql);
if ($result && $result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $countries_data[] = $row;
    }
}
?>
<div>Current UK Date & Time: <?= $ukDateTime ?></div>
<script>
window.ukHour = <?= $ukHour ?>;
window.ukDay = <?= $ukDay ?>;
window.ukDateTime = "<?= $ukDateTime ?>";
window.prices = <?= json_encode($prices) ?>;
window.promoInfo = <?= json_encode([
    'code' => $_SESSION['step2']['promo'] ?? '',
    'type' => $_SESSION['step2']['promo_type'] ?? '',
    'value' => $_SESSION['step2']['promo_value'] ?? 0,
    'promo_id' => $_SESSION['step2']['promo_id'] ?? null,
    'error' => $_SESSION['step2']['promo_error'] ?? ''
]) ?>;

window.addons = <?= json_encode($_SESSION['step2']['addons'] ?? []) ?>;
// MODIFIED: Pass previously selected countries to JavaScript
window.selectedDriveCountries = <?= json_encode($_SESSION['step2']['drive_country'] ?? []) ?>; 
window.countriesData = <?= json_encode($countries_data) ?>;
</script>
<script src="step2.js" defer></script>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Step 2 - Choose Plan</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<?php include('link.php'); ?>
<style>
.price-breakdown { border: 1px solid #eee; padding: 15px; margin-bottom: 20px; border-radius: 8px; background-color: #f9f9f9; }
.price-breakdown h4 { margin-top: 0; color: #333; border-bottom: 1px solid #ddd; padding-bottom: 10px; }
.price-breakdown ul { list-style: none; padding: 0; margin: 0; }
.price-breakdown li { display: flex; justify-content: space-between; padding: 5px 0; font-size: 15px; }
.price-breakdown li span { color: #555; }
input[type="radio"]:disabled + label { color: #999; }
input[type="radio"]:disabled ~ div label { color: #999; }
.promo-error { color: red; font-size: 13px; margin-top: 5px; }

#idp-convention-display {
display: none;
margin-top: 10px;
padding: 15px;
background-color: #eef7ff;
border-left: 4px solid #007bff;
border-radius: 4px;
font-size: 14px;
color: #333;
}

/* NEW: Style for validation error messages */
.form-error {
color: #D8000C; /* Red color for errors */
font-weight: bold;
font-size: 14px;
margin-top: 10px;
display: none; /* Hide by default */
}
</style>
</head>
<body>
<?php include('header.php'); ?>
<section class="step-section steplicence">
<div class="step-header">
<h1>Apply for International Driving License</h1>
<p>Most accepted at the global level & trusted by travellers all around the world</p>
</div>
<div class="step-progress">
<div class="step"><span class="number">01</span><span class="label">Applicant's Details</span></div>
<div class="step active"><span class="number">02</span><span class="label">Choose Plan</span></div>
<div class="step"><span class="number">03</span><span class="label">Review</span></div>
<div class="step"><span class="number">04</span><span class="label">Payment</span></div>
</div>
</section>
<div class="licenceform">
<div class="container">
<div class="main-form-container">
<div class="form-container">
<h2>Choose Plan</h2>
<!-- Added ID to the form for validation -->
<form method="post" action="step2.php" id="step2-form">
      <div class="formfield">
        <label class="softhard-copy">
          <div class="span-soft">
            <input type="radio" name="plan" value="Soft Copy" <?= (isset($_SESSION['step2']['plan']) && $_SESSION['step2']['plan']==='Soft Copy') ? 'checked' : '' ?> checked>
            <?php 
              $softCopyImgSrc = !empty($prices['soft_copy_file']) 
                  ? "/dhl/admin/uploads/" . htmlspecialchars($prices['soft_copy_file']) 
                  : "assets/images/placeholder.svg"; // Fallback placeholder
            ?>
            <img src="<?= $softCopyImgSrc ?>" alt="Soft Copy" width="100">
          </div>
          <div><b>Soft Copy</b><br><small>Email delivery</small></div>
        </label>

        <label class="softhard-copy">
          <div class="span-soft">
            <input type="radio" name="plan" value="Hard Copy" <?= (isset($_SESSION['step2']['plan']) && $_SESSION['step2']['plan']==='Hard Copy') ? 'checked' : '' ?>>
            <?php 
              $hardCopyImgSrc = !empty($prices['hard_copy_file']) 
                  ? "/dhl/admin/uploads/" . htmlspecialchars($prices['hard_copy_file']) 
                  : "assets/images/placeholder.svg"; // Fallback placeholder
            ?>
            <img src="<?= $hardCopyImgSrc ?>" alt="Hard Copy" width="100">
          </div>
          <div><b>Hard Copy</b><br><small>Home delivery</small></div>
        </label>
      </div>

      <div class="type_label">
        <label class="pillbtn">Type *</label>
      </div>
      <label class='type_label'>
        <input type="radio" name="type" value="Normal" <?= (isset($_SESSION['step2']['type']) && $_SESSION['step2']['type']==='Normal') ? 'checked' : '' ?> checked>Normal
      </label>
      <label class='type_label'>
        <input type="radio" id="urgentRadio" name="type" value="Urgent" <?= (isset($_SESSION['step2']['type']) && $_SESSION['step2']['type']==='Urgent') ? 'checked' : '' ?>>Urgent
      </label>
      <br><br>

      <label>Where your license was issued *</label>
      <select id="license_issue_label" name="license_country" required>
        <option value="">Select Country</option>
      </select>
      
      <div id="idp-convention-display"></div>
      <br><br>

      <!-- START: MODIFIED SECTION FOR MULTI-SELECT -->
      <label>Where do you intend to drive? (Select one or more) *</label>
      <select id="drive_country" name="drive_country[]" required multiple>
        <!-- Options will be populated by JavaScript -->
      </select><br><br>
      <!-- END: MODIFIED SECTION -->

      <div class="pillbtn-wrap">
    <label class="pillbtn">Classes of Driving License *</label>

    <?php
    if (!empty($driving_license_classes_data)) {
        foreach ($driving_license_classes_data as $class) {

            $label = htmlspecialchars($class['label']);
            $price = htmlspecialchars(floatval($class['price']));

            // Only show uploaded image — NO FALLBACK
            $icon = "";
            if (!empty($class['image'])) {
                $icon = "/dhl/admin/uploads/" . htmlspecialchars($class['image']);
            }

            // Keep selected values
            $checked = (isset($_SESSION['step2']['license_class']) &&
                        in_array($class['label'], $_SESSION['step2']['license_class'] ?? []))
                        ? 'checked' : '';

            echo "<label>
                    <input type='checkbox' name='license_class[]' value='{$label}' data-price='{$price}' {$checked}>
                    " . (!empty($icon) ? "<img src='{$icon}' alt='{$label}' width='40' style='margin-right:6px'>" : "") . "
                    {$label}
                  </label>";
        }

    } else {
        echo "<p>No driving license classes available.</p>";
    }
    ?>

    <div id='license-class-error' class='form-error'></div>
</div>
<br>


      <div class="productcard">
        <label>Products *</label>
        <div class="productcard-wrap">
          <label class="softhard-copy-pro">
            <input type="radio" name="productbooklet" value="Booklet" <?= (isset($_SESSION['step2']['productbooklet']) && $_SESSION['step2']['productbooklet']==='Booklet') ? 'checked' : 'checked' ?>>
            <?php
            // Booklet Image: Use DB image if available, else fallback to existing assets/card.png
            $bookletImgSrc = !empty($prices['booklet_front_image']) 
                ? "/dhl/admin/uploads/" . htmlspecialchars($prices['booklet_front_image']) 
                : "assets/card.png";
            ?>
            <img src="<?= $bookletImgSrc ?>" height="200px" alt="Booklet">
            <div><b>Booklet</b></div>
          </label>

          <label class="softhard-copy-pro">
            <input type="radio" name="productbooklet" value="Booklet + Card" <?= (isset($_SESSION['step2']['productbooklet']) && $_SESSION['step2']['productbooklet']==='Booklet + Card') ? 'checked' : '' ?>>
            <?php
            // Booklet + Card Image: Use DB image if available, else fallback to existing assets/slide.png
            $bookletCardImgSrc = !empty($prices['booklet_card_booklet_front_image']) 
                ? "/dhl/admin/uploads/" . htmlspecialchars($prices['booklet_card_booklet_front_image']) 
                : "assets/slide.png";
            ?>
            <img src="<?= $bookletCardImgSrc ?>" height="200px" alt="Booklet + Card">
            <div><b>Booklet + Card</b></div>
          </label>
        </div>
      </div>

      <div id="validitySection" class="productcard-validity">
            <label>Validity *</label>
            <select id="validity" name="validity" required></select>
          </div><br>
          
          <div id="addonsSection">
            <label>Add-ons</label>
            <div id="addonsContainer" class="add-ons"></div>
          </div>

      <div class="mt-2 mb-4">
        <label>Apply Promo Code</label><br>
        <input type="text" name="promo" placeholder="Promo code" value="<?= htmlspecialchars($_SESSION['step2']['promo'] ?? '') ?>">
        <div id="promoError" class="promo-error"><?= htmlspecialchars($_SESSION['step2']['promo_error'] ?? '') ?></div>
      </div>

      <div class="price-breakdown">
        <h4>Price Summary</h4>
        <ul>
          <li style="display:none"><span>Copy Type (Soft/Hard):</span> <strong id="breakdown-copy-price">£0.00</strong></li>
          <li><span>Processing Type (Urgent):</span> <strong id="breakdown-type-price">£0.00</strong></li>
          <li style="display:none"><span>Classes of Driving License:</span> <strong id="breakdown-license-classes-price">£0.00</strong></li>
          <li style="display:none"><span>Product Booklet/Card:</span> <strong id="breakdown-product-price">£0.00</strong></li>
          <li><span>Validity:</span> <strong id="breakdown-validity-price">£0.00</strong></li>
          <li><span>Add-ons:</span> <strong id="breakdown-addons-price">£0.00</strong></li>
          <li><span>Discount:</span> <strong id="breakdown-discount">£0.00</strong></li>
        </ul>
        <div style="text-align: right; font-size: 22px; font-weight: bold; border-top: 2px solid #333; padding-top: 10px;">
          Total: <strong id="totalAmount">£0.00</strong>
        </div>
        <input type="hidden" id="totalInput" name="total" value="0">
      </div>

      <div class="back-continue-button-wrap">
        <a href="index.php"><button type="button" class="first-btn-cicle">Back</button></a>
        <button type="submit" name="step2_submit" class="btn secondary-btn-circle">Verify & Continue</button>
      </div>
    </form>
  </div>

  <div class="global-container">
    <?php include('stats-card.php'); ?>
  </div>
</div>
</div>
</div>
<?php include('footer.php'); ?>
<?php include('footerscript.php'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
const licenseCountrySelect = document.getElementById('license_issue_label');
const driveCountrySelect = document.getElementById('drive_country');
const conventionDisplay = document.getElementById('idp-convention-display');

// The country population logic is now handled in step2.js
// This script block keeps the form validation logic

// =================== NEW VALIDATION SCRIPT ===================
const step2Form = document.getElementById('step2-form');
if (step2Form) {
step2Form.addEventListener('submit', function(event) {
// --- 1. Validate Driving License Class Checkboxes ---
const checkedClasses = document.querySelectorAll("input[name='license_class[]']:checked");
const classErrorDiv = document.getElementById('license-class-error');
const classContainer = document.querySelector('.pillbtn-wrap');

// Hide previous error
classErrorDiv.style.display = 'none';

if (checkedClasses.length === 0) {
// Prevent the form from submitting
event.preventDefault();

// Show an error message
classErrorDiv.textContent = 'Please select at least one driving license class.';
classErrorDiv.style.display = 'block';

// Alert the user and scroll to the error
alert('You must select at least one driving license class to continue.');
classContainer.scrollIntoView({ behavior: 'smooth', block: 'center' });
return; // Stop further validation
}

// --- 2. You can add more checks for other fields here if needed ---
// Example for validity dropdown
const validitySelect = document.getElementById('validity');
if (validitySelect.value === '') {
event.preventDefault();
alert('Please select a validity period.');
validitySelect.scrollIntoView({ behavior: 'smooth', block: 'center' });
return;
}
});
}
});
</script>
</body>
</html>