<?php
session_start();
include '../db.php';

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

$userId = $_SESSION['user_id'];
$error = '';
$success = '';

// Fetch user data
$stmt = $conn->prepare("SELECT username, full_name FROM users WHERE id = ?");
$stmt->bind_param("i", $userId);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();

// Handle profile update (full name or password)
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $full_name = trim($_POST['full_name']);
    $password = $_POST['password'];
    $passwordConfirm = $_POST['password_confirm'];

    if ($password) {
        if ($password !== $passwordConfirm) {
            $error = "Passwords do not match.";
        } else {
            $hashedPassword = password_hash($password, PASSWORD_DEFAULT);
            $stmt = $conn->prepare("UPDATE users SET full_name=?, password=? WHERE id=?");
            $stmt->bind_param("ssi", $full_name, $hashedPassword, $userId);
            $stmt->execute();
            $success = "Profile and password updated successfully.";
            $_SESSION['full_name'] = $full_name;
        }
    } else {
        // Only update full name
        $stmt = $conn->prepare("UPDATE users SET full_name=? WHERE id=?");
        $stmt->bind_param("si", $full_name, $userId);
        $stmt->execute();
        $success = "Profile updated successfully.";
        $_SESSION['full_name'] = $full_name;
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Profile - Dashboard</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.6/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.6/dist/js/bootstrap.bundle.min.js"></script>
    <link rel="stylesheet" href="assets/css/style.css">
    <style>
        .circle-name { 
            width: 40px; height: 40px; 
            border-radius: 50%; background: #007bff; 
            color: #fff; text-align: center; line-height: 40px; 
            font-weight: bold; margin-right: 10px;
        }
    </style>
</head>
<body>
<div class="dashboard_wrapper">
    <!-- Sidebar -->
    <div class="left_panel">
        <div class="logo_box">
            <img src="../assets/images/logo.png" alt="logo" class="img-fluid full_logo">
            <img src="../assets/images/logo-icon.png" alt="logo" class="img-fluid logo_icon">
        </div>
         <?php include 'menu.php'; ?>
    </div>

    <!-- Right body panel -->
    <div class="right_body_panel">
        <div class="right_header_panel">
            <div class="left_toggle_button">
                <button class="btn toggle_btn" type="button"></button>
            </div>
            <div class="right_user_box">
                <div class="user_box_warp">
                    <span class="circle-name"><?php echo strtoupper(substr($user['full_name'],0,2)); ?></span>
                    <div class="user_name">
                        <h4><?php echo htmlspecialchars($user['full_name']); ?></h4>
                    </div>
                </div>
            </div>
        </div>

        <div class="body_wrapper_section p-3">
            <h3>Your Profile</h3>

            <?php if($error): ?>
                <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
            <?php endif; ?>
            <?php if($success): ?>
                <div class="alert alert-success"><?php echo htmlspecialchars($success); ?></div>
            <?php endif; ?>

            <form method="post" class="mb-3">
                <div class="mb-3">
                    <label>Username</label>
                    <input type="text" class="form-control" value="<?php echo htmlspecialchars($user['username']); ?>" disabled>
                </div>
                <div class="mb-3">
                    <label>Full Name</label>
                    <input type="text" name="full_name" class="form-control" value="<?php echo htmlspecialchars($user['full_name']); ?>" required>
                </div>
                <hr>
                <h5>Change Password (optional)</h5>
                <div class="mb-3">
                    <label>New Password</label>
                    <input type="password" name="password" class="form-control">
                </div>
                <div class="mb-3">
                    <label>Confirm Password</label>
                    <input type="password" name="password_confirm" class="form-control">
                </div>
                <button type="submit" class="btn btn-primary w-100">Update Profile</button>
            </form>

            <a href="index.php" class="btn btn-secondary w-100 mt-2">Back to Dashboard</a>
            <a href="logout.php" class="btn btn-danger w-100 mt-2">Logout</a>
        </div>
    </div>
</div>
</body>
</html>
